/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class EIPUtils {
    private static final Log log = LogFactory.getLog(EIPUtils.class);

    public static List getMatchingElements(SOAPEnvelope envelope, SynapseXPath expression) throws JaxenException {
        return EIPUtils.getMatchingElements(envelope, null, expression);
    }

    public static List getMatchingElements(SOAPEnvelope envelope, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        Object o = expression.evaluate(envelope, synCtxt);
        if (o instanceof OMNode) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(o);
            return list;
        }
        if (o instanceof List) {
            return (List)o;
        }
        return new ArrayList();
    }

    public static List<OMNode> getDetachedMatchingElements(SOAPEnvelope envelope, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        ArrayList<OMNode> elementList = new ArrayList<OMNode>();
        Object o = expression.evaluate(envelope, synCtxt);
        if (o instanceof OMNode) {
            elementList.add(((OMNode)o).detach());
        } else if (o instanceof List) {
            for (Object elem : (List)o) {
                if (!(elem instanceof OMNode)) continue;
                elementList.add(((OMNode)elem).detach());
            }
        }
        return elementList;
    }

    public static void enrichEnvelope(SOAPEnvelope envelope, SOAPEnvelope enricher, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        List elementList = EIPUtils.getMatchingElements(envelope, synCtxt, expression);
        List list = EIPUtils.getMatchingElements(enricher, synCtxt, expression);
        if (EIPUtils.checkNotEmpty(elementList) && EIPUtils.checkNotEmpty(list) || !EIPUtils.checkNotEmpty(elementList) && EIPUtils.checkNotEmpty(list)) {
            SOAPBody enrichingElement;
            Object o;
            if (EIPUtils.checkNotEmpty(elementList) && (o = elementList.get(0)) instanceof OMElement && ((OMElement)o).getParent() != null && ((OMElement)o).getParent() instanceof OMElement) {
                enrichingElement = (OMElement)((OMElement)o).getParent();
                SOAPBody body = envelope.getBody();
                if (!EIPUtils.isBody((OMElement)body, (OMElement)enrichingElement)) {
                    SOAPBody nonBodyElem = enrichingElement;
                    enrichingElement = envelope.getBody();
                    EIPUtils.addChildren(elementList, (OMElement)enrichingElement);
                    while (!EIPUtils.isBody((OMElement)body, (OMElement)nonBodyElem.getParent())) {
                        nonBodyElem = (OMElement)nonBodyElem.getParent();
                    }
                    nonBodyElem.detach();
                }
            }
            enrichingElement = envelope.getBody();
            if (list != null) {
                EIPUtils.addChildren(list, (OMElement)enrichingElement);
            }
        } else {
            throw new SynapseException("Could not find matching elements to aggregate.");
        }
    }

    private static boolean isBody(OMElement body, OMElement enrichingElement) {
        try {
            return body.getLocalName().equals(enrichingElement.getLocalName()) && body.getNamespace().getNamespaceURI().equals(enrichingElement.getNamespace().getNamespaceURI());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private static boolean checkNotEmpty(List list) {
        return list != null && !list.isEmpty();
    }

    private static void addChildren(List list, OMElement element) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o != null && o instanceof OMElement) {
                element.addChild((OMNode)((OMElement)o));
            }
            itr.remove();
        }
    }

    public static String getTemplatePropertyMapping(String templateName, String parameter) {
        return templateName + ":" + parameter;
    }

    public static void createSynapseEIPTemplateProperty(MessageContext synCtxt, String templateName, String paramName, Object value) {
        String targetSynapsePropName = EIPUtils.getTemplatePropertyMapping(templateName, paramName);
        synCtxt.setProperty(targetSynapsePropName, value);
    }
}

