/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.xml.SwitchCase;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

public class SwitchMediator
extends AbstractMediator
implements ManagedLifecycle {
    private SynapseXPath source = null;
    private final List<SwitchCase> cases = new ArrayList<SwitchCase>();
    private SwitchCase defaultCase = null;

    @Override
    public void init(SynapseEnvironment se) {
        for (SwitchCase swCase : this.cases) {
            swCase.init(se);
        }
        if (this.defaultCase != null) {
            this.defaultCase.init(se);
        }
    }

    @Override
    public void destroy() {
        for (SwitchCase swCase : this.cases) {
            swCase.destroy();
        }
        if (this.defaultCase != null) {
            this.defaultCase.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Switch mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        int parentsEffectiveTraceState = synCtx.getTracingState();
        this.setEffectiveTraceState(synCtx);
        String sourceText = this.source.stringValueOf(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("XPath : " + (Object)((Object)this.source) + " evaluates to : " + sourceText);
        }
        try {
            if ((sourceText == null || this.cases.isEmpty()) && this.defaultCase != null) {
                synLog.traceOrDebug("Source XPath evaluated to : null or no switch cases found. Executing the default case");
                boolean bl = this.defaultCase.mediate(synCtx);
                return bl;
            }
            for (SwitchCase swCase : this.cases) {
                if (swCase == null || !swCase.matches(sourceText)) continue;
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Matching case found : " + swCase.getRegex());
                }
                boolean bl = swCase.mediate(synCtx);
                return bl;
            }
            if (this.defaultCase != null) {
                synLog.traceOrDebug("None of the switch cases matched - executing default");
                boolean bl = this.defaultCase.mediate(synCtx);
                return bl;
            }
            synLog.traceOrDebug("None of the switch cases matched - no default case");
        }
        finally {
            synCtx.setTracingState(parentsEffectiveTraceState);
        }
        synLog.traceOrDebug("End : Switch mediator");
        return true;
    }

    public void addCase(SwitchCase m) {
        this.cases.add(m);
    }

    public List<SwitchCase> getCases() {
        return this.cases;
    }

    public SynapseXPath getSource() {
        return this.source;
    }

    public void setSource(SynapseXPath source) {
        this.source = source;
    }

    public SwitchCase getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(SwitchCase defaultCase) {
        this.defaultCase = defaultCase;
    }

    @Override
    public boolean isContentAware() {
        if (this.source != null) {
            return this.source.isContentAware();
        }
        return false;
    }
}

