/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.template;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.eip.EIPUtils;

public class TemplateContext {
    private String fName;
    private Collection<String> parameters;
    private Map mappedValues;

    TemplateContext(String name, Collection<String> parameters) {
        this.fName = name;
        this.parameters = parameters;
        this.mappedValues = new HashMap();
    }

    public void setupParams(MessageContext synCtxt) {
        for (String parameter : this.parameters) {
            String mapping;
            Object propertyValue;
            Object paramValue = this.getEvaluatedParamValue(synCtxt, parameter, (Value)(propertyValue = synCtxt.getProperty(mapping = EIPUtils.getTemplatePropertyMapping(this.fName, parameter))));
            if (paramValue == null) continue;
            this.mappedValues.put(parameter, paramValue);
            this.removeProperty(synCtxt, mapping);
        }
    }

    private Object getEvaluatedParamValue(MessageContext synCtx, String parameter, Value expression) {
        if (expression != null) {
            if (expression.getExpression() != null) {
                if (expression.hasExprTypeKey()) {
                    if (expression.hasPropertyEvaluateExpr()) {
                        return expression.evalutePropertyExpression(synCtx);
                    }
                    return expression.getExpression();
                }
                return expression.evaluateValue(synCtx);
            }
            if (expression.getKeyValue() != null) {
                return expression.evaluateValue(synCtx);
            }
        }
        return null;
    }

    private void removeProperty(MessageContext synCtxt, String deletedMapping) {
        Set keys = synCtxt.getPropertyKeySet();
        if (keys != null) {
            keys.remove(deletedMapping);
        }
    }

    public Object getParameterValue(String paramName) {
        return this.mappedValues.get(paramName);
    }

    public String getName() {
        return this.fName;
    }

    public Collection getParameters() {
        return this.parameters;
    }
}

