/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.transform.Argument;
import org.apache.synapse.util.AXIOMUtils;

public class PayloadFactoryMediator
extends AbstractMediator {
    private String format;
    private Value formatKey = null;
    private boolean isFormatDynamic = false;
    private List<Argument> argumentList = new ArrayList<Argument>();
    private Pattern pattern = Pattern.compile("\\$(\\d)+");

    @Override
    public boolean mediate(MessageContext synCtx) {
        OMElement resultElement;
        SOAPBody soapBody = synCtx.getEnvelope().getBody();
        StringBuffer result = new StringBuffer();
        this.regexTransform(result, synCtx);
        try {
            resultElement = AXIOMUtil.stringToOM((String)result.toString());
        }
        catch (XMLStreamException e) {
            this.handleException("Unable to create a valid XML payload", synCtx);
            return false;
        }
        Iterator itr = soapBody.getChildElements();
        while (itr.hasNext()) {
            OMElement child = (OMElement)itr.next();
            child.detach();
        }
        QName resultQName = resultElement.getFirstElement().getQName();
        if (resultQName.getLocalPart().equals("Envelope") && (resultQName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") || resultQName.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"))) {
            SOAPEnvelope soapEnvelope = AXIOMUtils.getSOAPEnvFromOM(resultElement.getFirstElement());
            if (soapEnvelope != null) {
                try {
                    synCtx.setEnvelope(soapEnvelope);
                }
                catch (AxisFault axisFault) {
                    this.handleException("Unable to attach SOAPEnvelope", (Exception)((Object)axisFault), synCtx);
                }
            }
        } else {
            Iterator itr2 = resultElement.getChildElements();
            while (itr2.hasNext()) {
                OMElement child = (OMElement)itr2.next();
                soapBody.addChild((OMNode)child);
            }
        }
        return true;
    }

    private void regexTransform(StringBuffer result, MessageContext synCtx) {
        if (this.isFormatDynamic()) {
            String key = this.formatKey.evaluateValue(synCtx);
            OMElement element = (OMElement)synCtx.getEntry(key);
            this.removeIndentations(element);
            String format2 = element.toString();
            this.replace(format2, result, synCtx);
        } else {
            this.replace(this.format, result, synCtx);
        }
    }

    private void replace(String format, StringBuffer result, MessageContext synCtx) {
        Object[] argValues = this.getArgValues(synCtx);
        Matcher matcher = this.pattern.matcher("<dummy>" + format + "</dummy>");
        while (matcher.find()) {
            String matchSeq = matcher.group();
            int argIndex = Integer.parseInt(matchSeq.substring(1));
            matcher.appendReplacement(result, argValues[argIndex - 1].toString());
        }
        matcher.appendTail(result);
    }

    private void removeIndentations(OMElement element) {
        ArrayList<OMText> removables = new ArrayList<OMText>();
        this.removeIndentations(element, removables);
        for (OMText node : removables) {
            node.detach();
        }
    }

    private void removeIndentations(OMElement element, List<OMText> removables) {
        Iterator children = element.getChildren();
        while (children.hasNext()) {
            Object next = children.next();
            if (next instanceof OMText) {
                OMText text = (OMText)next;
                if (!text.getText().trim().equals("")) continue;
                removables.add(text);
                continue;
            }
            if (!(next instanceof OMElement)) continue;
            this.removeIndentations((OMElement)next, removables);
        }
    }

    private Object[] getArgValues(MessageContext synCtx) {
        Object[] argValues = new Object[this.argumentList.size()];
        for (int i = 0; i < this.argumentList.size(); ++i) {
            String value;
            Argument arg = this.argumentList.get(i);
            if (arg.getValue() != null) {
                value = arg.getValue();
                if (!this.isXML(value)) {
                    value = StringEscapeUtils.escapeXml((String)value);
                }
                value = Matcher.quoteReplacement(value);
                argValues[i] = value;
                continue;
            }
            if (arg.getExpression() != null) {
                value = arg.getExpression().stringValueOf(synCtx);
                if (value != null) {
                    if (!this.isXML(value)) {
                        value = StringEscapeUtils.escapeXml((String)value);
                    }
                    value = Matcher.quoteReplacement(value);
                    argValues[i] = value;
                    continue;
                }
                argValues[i] = "";
                continue;
            }
            this.handleException("Unexpected arg type detected", synCtx);
        }
        return argValues;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void addArgument(Argument arg) {
        this.argumentList.add(arg);
    }

    public List<Argument> getArgumentList() {
        return this.argumentList;
    }

    private boolean isXML(String value) {
        try {
            AXIOMUtil.stringToOM((String)value);
        }
        catch (XMLStreamException ignore) {
            return false;
        }
        catch (OMException ignore) {
            return false;
        }
        return true;
    }

    public Value getFormatKey() {
        return this.formatKey;
    }

    public void setFormatKey(Value key) {
        this.formatKey = key;
    }

    public void setFormatDynamic(boolean formatDynamic) {
        this.isFormatDynamic = formatDynamic;
    }

    public boolean isFormatDynamic() {
        return this.isFormatDynamic;
    }
}

