/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.transform.url.RewriteRule;
import org.apache.synapse.mediators.transform.url.URIFragments;

public class URLRewriteMediator
extends AbstractMediator {
    private List<RewriteRule> rules = new ArrayList<RewriteRule>();
    private String inputProperty;
    private String outputProperty;

    @Override
    public boolean mediate(MessageContext messageContext) {
        URIFragments fragments;
        URI inputURI = this.getInputAddress(messageContext);
        if (inputURI != null) {
            try {
                URL url = new URL(inputURI.toString());
            }
            catch (MalformedURLException e) {
                this.handleException("Malformed URL when processing " + inputURI, e, messageContext);
            }
            fragments = new URIFragments(inputURI);
        } else {
            fragments = new URIFragments();
        }
        try {
            for (RewriteRule r : this.rules) {
                r.rewrite(fragments, messageContext);
            }
            if (this.outputProperty != null) {
                messageContext.setProperty(this.outputProperty, fragments.toURIString());
            } else {
                messageContext.setTo(new EndpointReference(fragments.toURIString()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("URL Rewrite Mediator has rewritten the address url : \n " + messageContext.getEnvelope()));
            }
        }
        catch (URISyntaxException e) {
            this.handleException("Error while constructing a URI from the fragments", e, messageContext);
        }
        return true;
    }

    private URI getInputAddress(MessageContext messageContext) {
        String uriString = null;
        if (this.inputProperty != null) {
            Object prop = messageContext.getProperty(this.inputProperty);
            if (prop != null && prop instanceof String) {
                uriString = (String)prop;
            }
        } else if (messageContext.getTo() != null) {
            uriString = messageContext.getTo().getAddress();
        }
        if (uriString != null) {
            try {
                return new URI(uriString);
            }
            catch (URISyntaxException e) {
                this.handleException("Malformed input URI: " + uriString, e, messageContext);
            }
        }
        return null;
    }

    public void addRule(RewriteRule rule) {
        this.rules.add(rule);
    }

    public List<RewriteRule> getRules() {
        return this.rules;
    }

    public String getInputProperty() {
        return this.inputProperty;
    }

    public void setInputProperty(String inputProperty) {
        this.inputProperty = inputProperty;
    }

    public String getOutputProperty() {
        return this.outputProperty;
    }

    public void setOutputProperty(String outputProperty) {
        this.outputProperty = outputProperty;
    }
}

