/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.forward;

import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.message.processors.forward.MessageStoreServiceClient;
import org.apache.synapse.util.MessageHelper;

public class BlockingMessageSender {
    private MessageStoreServiceClient sc = null;
    public static final String DEFAULT_CLIENT_REPO = "./samples/axis2Client/client_repo";
    public static final String DEFAULT_AXIS2_XML = "./samples/axis2Client/client_repo/conf/axis2.xml";
    private String clientRepository = null;
    private String axis2xml = null;
    private static Log log = LogFactory.getLog(BlockingMessageSender.class);
    private ConfigurationContext configurationContext = null;

    public void init() {
        try {
            this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
            this.sc = new MessageStoreServiceClient(this.configurationContext, null);
        }
        catch (AxisFault e) {
            String msg = "Error initializing BlockingMessageSender : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    public MessageContext send(EndpointDefinition endpoint, MessageContext messageIn) throws Exception {
        String serviceUrl = endpoint.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start Sending the Message ");
        }
        try {
            MessageContext messageOut = MessageHelper.cloneMessageContext(messageIn);
            Options options = new Options();
            options.setTo(new EndpointReference(serviceUrl));
            if (messageIn.getSoapAction() != null) {
                options.setAction(messageIn.getSoapAction());
            } else if (messageIn.isSOAP11()) {
                options.setProperty("disableSoapAction", (Object)true);
            } else {
                Axis2MessageContext axis2smc = (Axis2MessageContext)messageOut;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.getTransportOut().addParameter(new Parameter("OmitSOAP12Action", (Object)true));
            }
            org.apache.axis2.context.MessageContext axis2Ctx = ((Axis2MessageContext)messageOut).getAxis2MessageContext();
            boolean outOnlyMessage = this.isOutOnly(messageIn, axis2Ctx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking service Url " + serviceUrl + " with Message" + messageIn.getMessageID()));
            }
            options.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
            this.sc.removeHeaders();
            Iterator itr = axis2Ctx.getEnvelope().getHeader().getChildren();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (!(o instanceof OMElement)) continue;
                this.sc.addHeader((OMElement)o);
            }
            if (endpoint.isUseMTOM()) {
                options.setProperty("enableMTOM", (Object)"true");
            } else if (endpoint.isUseSwa()) {
                options.setProperty("enableSwA", (Object)"true");
            }
            if (endpoint.isForcePOX()) {
                axis2Ctx.setDoingREST(true);
            }
            this.sc.setOptions(options);
            OMElement result = null;
            try {
                OMElement payload = axis2Ctx.getEnvelope().getBody().getFirstElement();
                if (outOnlyMessage) {
                    this.sc.sendRobust(payload, axis2Ctx);
                } else {
                    result = this.sc.sendReceive(payload);
                }
            }
            catch (Exception axisFault) {
                if (!outOnlyMessage) {
                    messageOut.setProperty("blocking.sender.error", "true");
                    return messageOut;
                }
                log.error((Object)("Error sending Message to url : " + serviceUrl), (Throwable)axisFault);
                throw new Exception("Error while Sending Message", axisFault);
            }
            if (!outOnlyMessage && result != null) {
                String soapNamespaceURI = axis2Ctx.getEnvelope().getNamespace().getNamespaceURI();
                SOAPEnvelope envelope = this.createSOAPEnvelope(result, soapNamespaceURI);
                axis2Ctx.setEnvelope(envelope);
                return messageOut;
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error sending Message to url : " + serviceUrl), (Throwable)axisFault);
            throw new Exception("Error while Sending message ", axisFault);
        }
        return null;
    }

    private boolean isOutOnly(MessageContext messageIn, org.apache.axis2.context.MessageContext axis2Ctx) {
        if ("true".equals(messageIn.getProperty("OUT_ONLY"))) {
            return true;
        }
        if (axis2Ctx.getOperationContext() != null) {
            return "http://www.w3.org/ns/wsdl/in-only".equals(axis2Ctx.getOperationContext().getAxisOperation().getMessageExchangePattern());
        }
        return false;
    }

    public String getClientRepository() {
        return this.clientRepository;
    }

    public void setClientRepository(String clientRepository) {
        this.clientRepository = clientRepository;
    }

    public String getAxis2xml() {
        return this.axis2xml;
    }

    public void setAxis2xml(String axis2xml) {
        this.axis2xml = axis2xml;
    }

    private SOAPEnvelope createSOAPEnvelope(OMElement payload, String soapNamespaceUri) {
        SOAPFactory soapFactory = null;
        soapFactory = soapNamespaceUri.equals("http://www.w3.org/2003/05/soap-envelope") ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)payload);
        return envelope;
    }
}

