/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.forward;

import java.util.Map;
import java.util.Set;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.message.processors.forward.BlockingMessageSender;
import org.apache.synapse.message.processors.forward.ScheduledMessageForwardingProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class ForwardingJob
implements StatefulJob {
    private static final Log log = LogFactory.getLog(ForwardingJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jdm = jobExecutionContext.getMergedJobDataMap();
        MessageStore messageStore = (MessageStore)jdm.get((Object)"message.store");
        Map parameters = (Map)jdm.get((Object)"parameters");
        BlockingMessageSender sender = (BlockingMessageSender)jdm.get((Object)"blocking.sender");
        ScheduledMessageForwardingProcessor processor = (ScheduledMessageForwardingProcessor)jdm.get((Object)"processor.instance");
        int maxDeliverAttempts = -1;
        String mdaParam = (String)parameters.get("max.delivery.attempts");
        if (mdaParam != null && (maxDeliverAttempts = Integer.parseInt(mdaParam)) == 0) {
            processor.deactivate();
        }
        if (!processor.isActive() || messageStore == null) {
            return;
        }
        boolean errorStop = false;
        while (!errorStop) {
            MessageContext messageContext = messageStore.peek();
            if (messageContext != null) {
                String targetEp;
                AxisConfiguration configuration;
                String myServerName;
                String serverName = (String)messageContext.getProperty("SynapseConfig.ServerName");
                if (serverName != null && messageContext instanceof Axis2MessageContext && !serverName.equals(myServerName = ForwardingJob.getAxis2ParameterValue(configuration = ((Axis2MessageContext)messageContext).getAxis2MessageContext().getConfigurationContext().getAxisConfiguration(), "SynapseConfig.ServerName"))) {
                    return;
                }
                Set proSet = messageContext.getPropertyKeySet();
                if (proSet != null && proSet.contains("blocking.sender.error")) {
                    proSet.remove("blocking.sender.error");
                }
                if ((targetEp = (String)messageContext.getProperty("target.endpoint")) != null) {
                    Endpoint ep = messageContext.getEndpoint(targetEp);
                    if (ep instanceof AddressEndpoint) {
                        try {
                            Mediator mediator;
                            String seq;
                            MessageContext outCtx = sender.send(((AddressEndpoint)ep).getDefinition(), messageContext);
                            if (outCtx != null && "true".equals(outCtx.getProperty("blocking.sender.error"))) {
                                if (maxDeliverAttempts > 0) {
                                    processor.incrementSendAttemptCount();
                                }
                                if (parameters != null && parameters.get("message.processor.fault.sequence") != null) {
                                    seq = (String)parameters.get("message.processor.fault.sequence");
                                    mediator = outCtx.getSequence(seq);
                                    if (mediator != null) {
                                        mediator.mediate(outCtx);
                                    } else {
                                        log.warn((Object)("Can't Send the fault Message , Sequence " + seq + " Does not Exist"));
                                    }
                                }
                                if (maxDeliverAttempts > 0 && processor.getSendAttemptCount() >= maxDeliverAttempts) {
                                    processor.deactivate();
                                }
                                errorStop = true;
                                continue;
                            }
                            if (outCtx == null) {
                                messageStore.poll();
                                processor.resetSentAttemptCount();
                                continue;
                            }
                            if (parameters != null && parameters.get("message.processor.reply.sequence") != null && outCtx != null) {
                                seq = (String)parameters.get("message.processor.reply.sequence");
                                mediator = outCtx.getSequence(seq);
                                if (mediator != null) {
                                    mediator.mediate(outCtx);
                                } else {
                                    log.warn((Object)("Can't Send the Out Message , Sequence " + seq + " Does not Exist"));
                                }
                            }
                            processor.resetSentAttemptCount();
                            messageStore.poll();
                        }
                        catch (Exception e) {
                            if (maxDeliverAttempts > 0) {
                                processor.incrementSendAttemptCount();
                                if (processor.getSendAttemptCount() >= maxDeliverAttempts) {
                                    processor.deactivate();
                                }
                            }
                            errorStop = true;
                            log.error((Object)"Error Forwarding Message ", (Throwable)e);
                        }
                        continue;
                    }
                    log.warn((Object)("Address Endpoint Named " + targetEp + " not found.Hence removing " + "the message form store"));
                    messageStore.poll();
                    continue;
                }
                log.warn((Object)"Property target.endpoint not found in the message context , Hence removing the message ");
                messageStore.poll();
                continue;
            }
            errorStop = true;
        }
    }

    private BlockingMessageSender initMessageSender(Map<String, Object> params) {
        BlockingMessageSender sender = null;
        String axis2repo = (String)params.get("axis2.repo");
        String axis2Config = (String)params.get("axis2.config");
        sender = new BlockingMessageSender();
        if (axis2repo != null) {
            sender.setClientRepository(axis2repo);
        }
        if (axis2Config != null) {
            sender.setAxis2xml(axis2Config);
        }
        sender.init();
        return sender;
    }

    private static String getAxis2ParameterValue(AxisConfiguration axisConfiguration, String paramKey) {
        Parameter parameter = axisConfiguration.getParameter(paramKey);
        if (parameter == null) {
            return null;
        }
        Object value = parameter.getValue();
        if (value != null && value instanceof String) {
            return (String)parameter.getValue();
        }
        return null;
    }
}

