/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.forward;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.message.processors.forward.BlockingMessageSender;
import org.apache.synapse.message.processors.forward.MessageForwardingProcessorViewMBean;
import org.apache.synapse.message.processors.forward.ScheduledMessageForwardingProcessor;
import org.apache.synapse.message.store.MessageStore;

public class MessageForwardingProcessorView
implements MessageForwardingProcessorViewMBean {
    private MessageStore messageStore;
    private BlockingMessageSender sender;
    private ScheduledMessageForwardingProcessor processor;
    private static Log log = LogFactory.getLog(MessageForwardingProcessorView.class);

    public MessageForwardingProcessorView(MessageStore messageStore, BlockingMessageSender sender, ScheduledMessageForwardingProcessor processor) throws Exception {
        if (messageStore == null) {
            throw new Exception("Error , Can not create Message Forwarding Processor view with null message store");
        }
        this.messageStore = messageStore;
        if (sender == null) {
            throw new Exception("Error , Can not create Message Forwarding Processor view with null Message Sender");
        }
        this.sender = sender;
        if (processor == null) {
            throw new SynapseException("Error , Can not create Message Forwarding Processor view with null Message Processor");
        }
        this.processor = processor;
    }

    @Override
    public void resendAll() throws Exception {
        if (!this.processor.isActive()) {
            while (this.messageStore.peek() != null) {
                this.sendMessage(this.messageStore.peek(), true);
            }
        } else {
            throw new Exception("Message Processor is Active, Manual operations are not supported!");
        }
    }

    @Override
    public void deleteAll() throws Exception {
        if (this.processor.isActive()) {
            throw new Exception("Message Processor is Active, Manual operations are not supported!");
        }
        this.messageStore.clear();
    }

    @Override
    public List<String> messageIdList() throws Exception {
        if (!this.processor.isActive()) {
            MessageContext context;
            int size = this.messageStore.size();
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < size && (context = this.messageStore.get(i)) != null; ++i) {
                idList.add(context.getMessageID());
            }
            return idList;
        }
        throw new Exception("Message Processor is Active, Manual operations are not supported!");
    }

    @Override
    public void resend(String messageID) throws Exception {
        if (!this.processor.isActive()) {
            MessageContext msgCtx;
            if (messageID != null && !"".equals(messageID.trim()) && (msgCtx = this.messageStore.get(messageID)) != null) {
                this.sendMessage(msgCtx, false);
                this.messageStore.remove(messageID);
            }
        } else {
            throw new Exception("Message Processor is Active, Manual operations are not supported!");
        }
    }

    @Override
    public void delete(String messageID) throws Exception {
        if (!this.processor.isActive()) {
            if (messageID != null && !"".equals(messageID.trim())) {
                this.messageStore.remove(messageID);
            }
        } else {
            throw new Exception("Message Processor is Active, Manual operations are not supported!");
        }
    }

    @Override
    public String getEnvelope(String messageID) throws Exception {
        if (!this.processor.isActive()) {
            SOAPEnvelope env;
            MessageContext msgCtx;
            if (messageID != null && !"".equals(messageID.trim()) && (msgCtx = this.messageStore.get(messageID)) != null && (env = ((Axis2MessageContext)msgCtx).getAxis2MessageContext().getEnvelope()) != null) {
                return env.toString();
            }
        } else {
            throw new Exception("Message Processor is Active, Manual operations are not supported!");
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.messageStore.size();
    }

    @Override
    public boolean isActive() {
        assert (this.processor != null);
        return this.processor.isActive();
    }

    @Override
    public void activate() {
        assert (this.processor != null);
        this.processor.resetSentAttemptCount();
        this.processor.activate();
    }

    @Override
    public void deactivate() {
        assert (this.processor != null);
        this.processor.deactivate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(MessageContext messageContext, boolean delete) throws Exception {
        String targetEp;
        if (messageContext == null) throw new Exception("Error! Cant send Message Context : " + messageContext);
        Set proSet = messageContext.getPropertyKeySet();
        if (proSet != null && proSet.contains("blocking.sender.error")) {
            proSet.remove("blocking.sender.error");
        }
        if ((targetEp = (String)messageContext.getProperty("target.endpoint")) == null) {
            String logMsg = "Property target.endpoint not found in the message context , Hence removing the message ";
            log.warn((Object)logMsg);
            if (!delete) throw new Exception(logMsg);
            this.messageStore.poll();
            throw new Exception(logMsg);
        }
        Endpoint ep = messageContext.getEndpoint(targetEp);
        if (!(ep instanceof AddressEndpoint)) {
            String logMsg = "Address Endpoint Named " + targetEp + " not found.Hence removing " + "the message form store";
            log.warn((Object)logMsg);
            if (!delete) throw new Exception(logMsg);
            this.messageStore.poll();
            throw new Exception(logMsg);
        }
        try {
            MessageContext outCtx = this.sender.send(((AddressEndpoint)ep).getDefinition(), messageContext);
            if (!delete) return;
            this.messageStore.poll();
            return;
        }
        catch (Exception e) {
            log.error((Object)"Error Forwarding Message ", (Throwable)e);
            throw new Exception(e);
        }
    }
}

