/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.forward;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;

public class MessageStoreServiceClient
extends ServiceClient {
    public MessageStoreServiceClient(ConfigurationContext configContext, AxisService axisService) throws AxisFault {
        super(configContext, axisService);
    }

    public void sendRobust(OMElement elem, MessageContext orgi) throws AxisFault {
        MessageContext mc = new MessageContext();
        if (orgi.isDoingREST()) {
            mc.setDoingREST(true);
        }
        this.fillSOAPEnvelope(mc, elem);
        OperationClient mepClient = this.createClient(ANON_ROBUST_OUT_ONLY_OP);
        mepClient.addMessageContext(mc);
        mepClient.execute(true);
    }

    private void fillSOAPEnvelope(MessageContext messageContext, OMElement xmlPayload) throws AxisFault {
        messageContext.setServiceContext(this.getServiceContext());
        SOAPFactory soapFactory = this.getSOAPFactory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        if (xmlPayload != null) {
            envelope.getBody().addChild((OMNode)xmlPayload);
        }
        this.addHeadersToEnvelope(envelope);
        messageContext.setEnvelope(envelope);
    }

    private SOAPFactory getSOAPFactory() {
        String soapVersionURI = this.getOptions().getSoapVersionURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        return OMAbstractFactory.getSOAP11Factory();
    }
}

