/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.forward;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.processors.ScheduledMessageProcessor;
import org.apache.synapse.message.processors.forward.BlockingMessageSender;
import org.apache.synapse.message.processors.forward.ForwardingJob;
import org.apache.synapse.message.processors.forward.MessageForwardingProcessorView;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class ScheduledMessageForwardingProcessor
extends ScheduledMessageProcessor {
    public static final String BLOCKING_SENDER = "blocking.sender";
    private BlockingMessageSender sender = null;
    private volatile AtomicBoolean active = new AtomicBoolean(true);
    private volatile AtomicInteger sendAttempts = new AtomicInteger(0);
    private MessageForwardingProcessorView view;

    @Override
    public void init(SynapseEnvironment se) {
        String thisServerName = se.getServerContextInformation().getServerConfigurationInformation().getServerName();
        Object pinnedServersObj = this.parameters.get("pinnedServers");
        if (pinnedServersObj != null && pinnedServersObj instanceof String) {
            boolean pinned = false;
            String pinnedServers = (String)pinnedServersObj;
            StringTokenizer st = new StringTokenizer(pinnedServers, " ,");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (!thisServerName.equals(token)) continue;
                pinned = true;
            }
            if (!pinned) {
                this.log.info((Object)("Message processor '" + this.name + "' pinned on '" + pinnedServers + "' not starting on" + " this server '" + thisServerName + "'"));
                this.active = new AtomicBoolean(false);
            }
        }
        super.init(se);
        try {
            this.view = new MessageForwardingProcessorView(se.getSynapseConfiguration().getMessageStore(this.messageStore), this.sender, this);
        }
        catch (Exception e) {
            throw new SynapseException(e);
        }
        MBeanRegistrar.getInstance().registerMBean((Object)this.view, "Message Forwarding Processor view", this.getName());
    }

    @Override
    protected JobBuilder getJobBuilder() {
        JobBuilder jobBuilder = JobBuilder.newJob(ForwardingJob.class).withIdentity(this.name + "-forward job", "synapse.message.processor.quartz");
        return jobBuilder;
    }

    @Override
    protected JobDetail getJobDetail() {
        JobBuilder jobBuilder = this.getJobBuilder();
        JobDetail jobDetail = jobBuilder.build();
        return jobDetail;
    }

    @Override
    protected JobDataMap getJobDataMap() {
        JobDataMap jdm = new JobDataMap();
        this.sender = this.initMessageSender(this.parameters);
        jdm.put(BLOCKING_SENDER, (Object)this.sender);
        jdm.put("processor.instance", (Object)this);
        return jdm;
    }

    private BlockingMessageSender initMessageSender(Map<String, Object> params) {
        String axis2repo = (String)params.get("axis2.repo");
        String axis2Config = (String)params.get("axis2.config");
        this.sender = new BlockingMessageSender();
        if (axis2repo != null) {
            this.sender.setClientRepository(axis2repo);
        }
        if (axis2Config != null) {
            this.sender.setAxis2xml(axis2Config);
        }
        this.sender.init();
        return this.sender;
    }

    public BlockingMessageSender getSender() {
        return this.sender;
    }

    public void setSender(BlockingMessageSender sender) {
        this.sender = sender;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void activate() {
        this.active.set(true);
    }

    public void deactivate() {
        this.active.set(false);
    }

    public int getSendAttemptCount() {
        return this.sendAttempts.get();
    }

    public void incrementSendAttemptCount() {
        this.sendAttempts.incrementAndGet();
    }

    public void resetSentAttemptCount() {
        this.sendAttempts.set(0);
    }

    @Override
    public void destroy() {
        try {
            this.scheduler.deleteJob(new JobKey(this.name + "-forward job", "synapse.message.processor.quartz"));
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Error while destroying the task " + (Object)((Object)e)));
        }
        this.state = ScheduledMessageProcessor.State.DESTROY;
    }

    public MessageForwardingProcessorView getView() {
        return this.view;
    }
}

