/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.sampler;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.processors.ScheduledMessageProcessor;
import org.apache.synapse.message.processors.sampler.SamplingJob;
import org.apache.synapse.message.processors.sampler.SamplingProcessorView;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class SamplingProcessor
extends ScheduledMessageProcessor {
    private Log log = LogFactory.getLog(SamplingProcessor.class);
    public static final String CONCURRENCY = "concurrency";
    public static final String SEQUENCE = "sequence";
    private AtomicBoolean active = new AtomicBoolean(true);
    private SamplingProcessorView view;

    @Override
    public void init(SynapseEnvironment se) {
        String thisServerName = se.getServerContextInformation().getServerConfigurationInformation().getServerName();
        Object pinnedServersObj = this.parameters.get("pinnedServers");
        if (pinnedServersObj != null && pinnedServersObj instanceof String) {
            boolean pinned = false;
            String pinnedServers = (String)pinnedServersObj;
            StringTokenizer st = new StringTokenizer(pinnedServers, " ,");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (!thisServerName.equals(token)) continue;
                pinned = true;
            }
            if (!pinned) {
                this.log.info((Object)("Message processor '" + this.name + "' pinned on '" + pinnedServers + "' not starting on" + " this server '" + thisServerName + "'"));
                this.active = new AtomicBoolean(false);
            }
        }
        super.init(se);
        this.view = new SamplingProcessorView(this);
        MBeanRegistrar.getInstance().registerMBean((Object)this.view, "Message Sampling Processor view", this.getName());
    }

    @Override
    protected JobBuilder getJobBuilder() {
        JobBuilder jobBuilder = JobBuilder.newJob(SamplingJob.class).withIdentity(this.name + "-sampling-job", "synapse.message.processor.quartz");
        return jobBuilder;
    }

    @Override
    protected JobDetail getJobDetail() {
        JobBuilder jobBuilder = this.getJobBuilder();
        JobDetail jobDetail = jobBuilder.build();
        return jobDetail;
    }

    @Override
    protected JobDataMap getJobDataMap() {
        JobDataMap jdm = new JobDataMap();
        jdm.put("processor.instance", (Object)this);
        return jdm;
    }

    @Override
    public void destroy() {
        try {
            this.scheduler.deleteJob(new JobKey(this.name + "-sampling-job", "synapse.message.processor.quartz"));
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Error while destroying the task " + (Object)((Object)e)));
        }
        this.state = ScheduledMessageProcessor.State.DESTROY;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void activate() {
        this.active.set(true);
    }

    public void deactivate() {
        this.active.set(false);
    }

    public SamplingProcessorView getView() {
        return this.view;
    }
}

