/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.registry.url;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.registry.AbstractRegistry;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.registry.RegistryEntry;
import org.apache.synapse.registry.RegistryEntryImpl;

public class SimpleURLRegistry
extends AbstractRegistry
implements Registry {
    private static final Log log = LogFactory.getLog(SimpleURLRegistry.class);
    private static final int MAX_KEYS = 200;
    private String root = "";
    private final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMNode lookup(String key) {
        BufferedInputStream inputStream;
        URL url;
        if (log.isDebugEnabled()) {
            log.debug((Object)("==> Repository fetch of resource with key : " + key));
        }
        if ((url = SynapseConfigUtils.getURLFromPath(this.root + key, this.properties.get("synapse.home") != null ? this.properties.get("synapse.home").toString() : "")) == null) {
            return null;
        }
        try {
            URLConnection connection = SynapseConfigUtils.getURLConnection(url);
            if (connection == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot create a URLConnection for given URL : " + url));
                }
                return null;
            }
            connection.connect();
            inputStream = new BufferedInputStream(connection.getInputStream());
        }
        catch (IOException e) {
            return null;
        }
        OMElement result = null;
        if (inputStream != null) {
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                result = builder.getDocumentElement();
            }
            catch (OMException ignored) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The resource at the provided URL isn't well-formed XML,So,takes it as a text");
                }
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error in closing the input stream. ", (Throwable)e);
                }
                result = SynapseConfigUtils.readNonXML(url);
            }
            catch (XMLStreamException ignored) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The resource at the provided URL isn't well-formed XML,So,takes it as a text");
                }
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error in closing the input stream. ", (Throwable)e);
                }
                result = SynapseConfigUtils.readNonXML(url);
            }
            finally {
                try {
                    if (result != null && result.getParent() != null) {
                        result.detach();
                        OMDocument omDocument = this.omFactory.createOMDocument();
                        omDocument.addChild((OMNode)result);
                    }
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error in closing the input stream.", (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public RegistryEntry getRegistryEntry(String key) {
        URL url;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Perform RegistryEntry lookup for key : " + key));
        }
        if ((url = SynapseConfigUtils.getURLFromPath(this.root + key, this.properties.get("synapse.home") != null ? this.properties.get("synapse.home").toString() : "")) == null) {
            return null;
        }
        URLConnection connection = SynapseConfigUtils.getURLConnection(url);
        if (connection == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot create a URLConnection for given URL : " + url));
            }
            return null;
        }
        RegistryEntryImpl wre = new RegistryEntryImpl();
        wre.setKey(key);
        wre.setName(url.getFile());
        wre.setType(connection.getContentType());
        wre.setDescription("Resource at : " + url.toString());
        wre.setLastModified(connection.getLastModified());
        wre.setVersion(connection.getLastModified());
        if (connection.getExpiration() > 0L) {
            wre.setCachableDuration(connection.getExpiration() - System.currentTimeMillis());
        } else {
            wre.setCachableDuration(this.getCachableDuration());
        }
        return wre;
    }

    @Override
    public OMElement getFormat(Entry entry) {
        return null;
    }

    @Override
    public OMNode lookupFormat(String key) {
        return null;
    }

    @Override
    public void init(Properties properties) {
        super.init(properties);
        String value = properties.getProperty("root");
        if (value != null) {
            try {
                new URL(value);
                if (!value.endsWith("/")) {
                    value = value + "/";
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.root = value;
        } else {
            this.handleException("Parameter root is null");
        }
    }

    @Override
    public void delete(String path) {
    }

    @Override
    public void newResource(String path, boolean isDirectory) {
    }

    @Override
    public void updateResource(String path, Object value) {
    }

    @Override
    public void updateRegistryEntry(RegistryEntry entry) {
    }

    private long getCachableDuration() {
        String cachableDuration = (String)this.properties.get("cachableDuration");
        return cachableDuration == null ? 1500L : Long.parseLong(cachableDuration);
    }

    @Override
    public RegistryEntry[] getChildren(RegistryEntry entry) {
        URL url;
        if (entry == null) {
            RegistryEntryImpl entryImpl = new RegistryEntryImpl();
            entryImpl.setKey("");
            entry = entryImpl;
        }
        if ((url = SynapseConfigUtils.getURLFromPath(this.root + entry.getKey(), this.properties.get("synapse.home") != null ? this.properties.get("synapse.home").toString() : "")) == null) {
            return null;
        }
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                return null;
            }
            BufferedReader reader = null;
            try {
                String key;
                reader = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
                ArrayList<RegistryEntryImpl> entryList = new ArrayList<RegistryEntryImpl>();
                while ((key = reader.readLine()) != null) {
                    RegistryEntryImpl registryEntryImpl = new RegistryEntryImpl();
                    if (entry.getKey().equals("")) {
                        registryEntryImpl.setKey(key);
                    } else if (entry.getKey().endsWith("/")) {
                        registryEntryImpl.setKey(entry.getKey() + key);
                    } else {
                        registryEntryImpl.setKey(entry.getKey() + "/" + key);
                    }
                    entryList.add(registryEntryImpl);
                }
                RegistryEntry[] entries = new RegistryEntry[entryList.size()];
                for (int i = 0; i < entryList.size(); ++i) {
                    entries[i] = (RegistryEntry)entryList.get(i);
                }
                RegistryEntry[] registryEntryArray = entries;
                return registryEntryArray;
            }
            catch (Exception e) {
                throw new SynapseException("Error in reading the URL.");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        throw new SynapseException("Invalid protocol.");
    }

    @Override
    public RegistryEntry[] getDescendants(RegistryEntry entry) {
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        this.fillDescendants(entry, list);
        RegistryEntry[] descendants = new RegistryEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            descendants[i] = list.get(i);
        }
        return descendants;
    }

    private void fillDescendants(RegistryEntry parent, ArrayList<RegistryEntry> list) {
        RegistryEntry[] children = this.getChildren(parent);
        if (children != null) {
            for (RegistryEntry child : children) {
                if (child == null) continue;
                if (list.size() <= 200) {
                    this.fillDescendants(child, list);
                    continue;
                }
                break;
            }
        } else {
            list.add(parent);
        }
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

