/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.rest.version;

import org.apache.synapse.MessageContext;
import org.apache.synapse.rest.API;
import org.apache.synapse.rest.RESTUtils;
import org.apache.synapse.rest.version.AbstractVersionStrategy;

public class URLBasedVersionStrategy
extends AbstractVersionStrategy {
    String versionParam;

    public URLBasedVersionStrategy(API api, String version, String versionParam) {
        super(api, version, "url");
        this.versionParam = versionParam;
    }

    @Override
    public boolean isMatchingVersion(Object versionInfoObj) {
        String context;
        MessageContext msgContext = (MessageContext)versionInfoObj;
        String path = RESTUtils.getFullRequestPath(msgContext);
        String pathStringAfterContext = path.substring((context = this.getAPI().getContext()).length());
        if (pathStringAfterContext != null && !pathStringAfterContext.startsWith("/")) {
            return false;
        }
        int indexOfNextSlash = pathStringAfterContext.substring(1).indexOf("/");
        String incomingVersionStr = null;
        if (indexOfNextSlash != -1) {
            incomingVersionStr = pathStringAfterContext.substring(1, indexOfNextSlash + 1);
        } else {
            String versionStr;
            incomingVersionStr = versionStr = pathStringAfterContext.substring(1);
            if (versionStr.contains("?")) {
                incomingVersionStr = versionStr.substring(0, versionStr.indexOf("?"));
            }
        }
        return this.version.equals(incomingVersionStr);
    }

    @Override
    public String getVersionParam() {
        return this.versionParam;
    }

    public static void main(String[] args) {
        String version = "1.0.0";
        String path = "/test11.0.0/1.0/foo/abc/abc='asasa'";
        String context = "/test";
        String pathStringAfterContext = path.substring(context.length());
        System.out.println("pathStringAfterContext : " + pathStringAfterContext);
        int indexOfNextSlash = pathStringAfterContext.substring(1).indexOf("/");
        System.out.println(indexOfNextSlash);
        String incomingVersionStr = pathStringAfterContext.substring(1, indexOfNextSlash + 1);
        System.out.println("incomingVersionStr : " + incomingVersionStr);
        System.out.println(version.equals(incomingVersionStr));
    }
}

