/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.tasks;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.task.Task;
import org.apache.synapse.util.PayloadHelper;

public class MessageInjector
implements Task,
ManagedLifecycle {
    private Log log = LogFactory.getLog(MessageInjector.class);
    private OMElement message = null;
    private String to = null;
    private String format = null;
    private String soapAction = null;
    private SynapseEnvironment synapseEnvironment;
    public static final String SOAP11_FORMAT = "soap11";
    public static final String SOAP12_FORMAT = "soap12";
    public static final String POX_FORMAT = "pox";
    public static final String GET_FORMAT = "get";

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
    }

    public void setMessage(OMElement elem) {
        this.log.debug((Object)("set message " + elem.toString()));
        this.message = elem;
    }

    public void setTo(String url) {
        this.to = url;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void execute() {
        this.log.debug((Object)"execute");
        if (this.synapseEnvironment == null) {
            this.log.error((Object)"Synapse Environment not set");
            return;
        }
        if (this.message == null) {
            this.log.error((Object)"message not set");
            return;
        }
        if (this.to == null) {
            this.log.error((Object)"to address not set");
            return;
        }
        MessageContext mc = this.synapseEnvironment.createMessageContext();
        mc.pushFaultHandler(new MediatorFaultHandler(mc.getFaultSequence()));
        mc.setTo(new EndpointReference(this.to));
        if (this.format == null) {
            PayloadHelper.setXMLPayload(mc, this.message.cloneOMElement());
        } else {
            try {
                if (SOAP11_FORMAT.equalsIgnoreCase(this.format)) {
                    mc.setEnvelope(OMAbstractFactory.getSOAP11Factory().createSOAPEnvelope());
                } else if (SOAP12_FORMAT.equalsIgnoreCase(this.format)) {
                    mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
                } else if (POX_FORMAT.equalsIgnoreCase(this.format)) {
                    mc.setDoingPOX(true);
                } else if (GET_FORMAT.equalsIgnoreCase(this.format)) {
                    mc.setDoingGET(true);
                }
                PayloadHelper.setXMLPayload(mc, this.message.cloneOMElement());
            }
            catch (AxisFault axisFault) {
                String msg = "Error in setting the message payload : " + this.message;
                this.log.error((Object)msg, (Throwable)axisFault);
                throw new SynapseException(msg, axisFault);
            }
        }
        if (this.soapAction != null) {
            mc.setSoapAction(this.soapAction);
        }
        this.synapseEnvironment.injectMessage(mc);
    }

    @Override
    public void destroy() {
    }
}

