/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.endpoints.XMLToEndpointMapper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.registry.AbstractRegistry;
import org.apache.synapse.registry.RegistryEntry;
import org.apache.synapse.startup.tasks.RegistryResourceFetcherView;
import org.apache.synapse.startup.tasks.State;
import org.apache.synapse.task.Task;

public class RegistryResourceFetcher
implements Task,
ManagedLifecycle {
    private static Log log = LogFactory.getLog(RegistryResourceFetcher.class);
    public static final String SEQUENCE = "sequence";
    public static final String ENDPOINT = "endpoint";
    public static final String XML = "xml";
    public static final String TEXT = "text";
    private OMElement items;
    private List<RegistryResourceEntry> registryResources = new ArrayList<RegistryResourceEntry>();
    private SynapseConfiguration synapseConfiguration = null;
    private SynapseEnvironment synapseEnvironment = null;
    private AbstractRegistry registry = null;
    private int backOffFactor = 1;
    private int maxSuspendThreshold = 100;
    private int suspendThreshold = 4;
    private int currentFailedCount = 0;
    private int executionCount = 0;
    private int nextSuspendExecutionCount = 1;
    private long lastExecutionTime = 0L;
    private State state = State.INIT;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private RegistryResourceFetcherView view = null;

    public OMElement getItems() {
        return this.items;
    }

    public void setItems(OMElement items) {
        this.items = items;
    }

    public int getSuspendThreshold() {
        return this.suspendThreshold;
    }

    public int getMaxSuspendThreshold() {
        return this.maxSuspendThreshold;
    }

    public int getBackOffFactor() {
        return this.backOffFactor;
    }

    public void setBackOffFactor(int backOffFactor) {
        this.backOffFactor = backOffFactor;
    }

    public void setMaxSuspendThreshold(int maxSuspendThreshold) {
        this.maxSuspendThreshold = maxSuspendThreshold;
    }

    public void setSuspendThreshold(int suspendThreshold) {
        this.suspendThreshold = suspendThreshold;
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.items == null) {
            String msg = "resources configuration is required";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        Iterator it = this.items.getChildrenWithName(new QName("resource"));
        while (it.hasNext()) {
            OMElement resourceElement = (OMElement)it.next();
            String path = resourceElement.getText();
            String type = XML;
            OMAttribute typeAttribute = resourceElement.getAttribute(new QName("type"));
            if (typeAttribute != null) {
                type = typeAttribute.getAttributeValue();
            }
            this.registryResources.add(new RegistryResourceEntry(path, type));
        }
        this.synapseConfiguration = se.getSynapseConfiguration();
        this.registry = (AbstractRegistry)se.getSynapseConfiguration().getRegistry();
        this.synapseEnvironment = se;
        this.view = new RegistryResourceFetcherView(this);
        MBeanRegistrar.getInstance().registerMBean((Object)this.view, "ESB-Registry", "RegistryResourceFetcher");
        this.state = State.ACTIVE;
    }

    @Override
    public void destroy() {
        MBeanRegistrar.getInstance().unRegisterMBean("ESB-Registry", "RegistryResourceFetcher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Lock readerLock = this.lock.readLock();
        readerLock.lock();
        try {
            boolean execute = false;
            ++this.executionCount;
            if (this.state == State.SUSPENDED) {
                if (this.executionCount >= this.maxSuspendThreshold) {
                    execute = true;
                }
            } else if (this.state == State.BACK_OFF) {
                if (this.nextSuspendExecutionCount == this.executionCount) {
                    this.nextSuspendExecutionCount *= this.backOffFactor;
                    execute = true;
                }
            } else if (this.state == State.SUSPECT || this.state == State.ACTIVE) {
                execute = true;
            }
            if (!execute) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Skipping the execution because the Registry Fetching is at SUSPENDED state");
                }
                return;
            }
            for (RegistryResourceEntry key : this.registryResources) {
                if (this.state != State.ACTIVE) continue;
                Entry entry = this.synapseConfiguration.getEntryDefinition(key.getPath());
                if (entry == null) {
                    log.warn((Object)("A non remote entry has being specified: " + key.getPath()));
                    return;
                }
                if (key.getType().equals(SEQUENCE)) {
                    entry.setMapper(MediatorFactoryFinder.getInstance());
                } else if (key.getType().equals(ENDPOINT)) {
                    entry.setMapper(XMLToEndpointMapper.getInstance());
                }
                this.fetchEntry(key.getPath());
            }
            this.lastExecutionTime = System.currentTimeMillis();
        }
        finally {
            readerLock.unlock();
        }
    }

    private void fetchEntry(String key) {
        block15: {
            Map localRegistry = this.synapseConfiguration.getLocalRegistry();
            Object o = localRegistry.get(key);
            if (o != null && o instanceof Entry) {
                Entry entry = (Entry)o;
                if (this.registry != null) {
                    if (entry.isCached()) {
                        try {
                            Object resource = this.getResource(entry, this.synapseConfiguration.getProperties());
                            if (resource == null) {
                                log.warn((Object)("Failed to load the resource at the first time, non-existing resource: " + key));
                            } else {
                                entry.setExpiryTime(Long.MAX_VALUE);
                            }
                            this.onSuccess();
                        }
                        catch (Exception e) {
                            log.warn((Object)("Error while loading the resource " + key + " from the remote " + "registry. Previously cached value will be used. Check the " + "registry accessibility."));
                            this.onError();
                        }
                    } else {
                        try {
                            Object resource = this.getResource(entry, this.synapseConfiguration.getProperties());
                            if (resource == null) {
                                log.warn((Object)("Failed to load the resource at the first time, non-existing resource: " + key));
                                break block15;
                            }
                            entry.setExpiryTime(Long.MAX_VALUE);
                        }
                        catch (Exception e) {
                            log.warn((Object)("Failed to load the resource at the first time, non-existing resource: " + key));
                        }
                    }
                } else if (entry.isCached()) {
                    log.warn((Object)("The registry is no longer available in the Synapse configuration. Using the previously cached value for the resource : " + key));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Will not  evaluate the value of the remote entry with a key " + key + ",  because the registry is not available"));
                }
            }
        }
    }

    private Object getResource(Entry entry, Properties properties) {
        RegistryEntry re = this.registry.getRegistryEntry(entry.getKey());
        OMNode omNode = this.registry.lookup(entry.getKey());
        if (re == null) {
            return null;
        }
        if (!entry.isCached() || re.getVersion() == Long.MIN_VALUE || re.getVersion() != entry.getVersion() || re.getLastModified() >= this.lastExecutionTime) {
            entry.setEntryProperties(this.registry.getResourceProperties(entry.getKey()));
            entry.setVersion(re.getVersion());
            Object expiredValue = entry.getValue();
            if (entry.getMapper() != null) {
                entry.setValue(entry.getMapper().getObjectFromOMNode(omNode, properties));
                if (entry.getValue() instanceof SequenceMediator) {
                    SequenceMediator seq = (SequenceMediator)entry.getValue();
                    seq.setDynamic(true);
                    seq.setRegistryKey(entry.getKey());
                    seq.init(this.synapseEnvironment);
                } else if (entry.getValue() instanceof Endpoint) {
                    Endpoint ep = (Endpoint)entry.getValue();
                    ep.init(this.synapseEnvironment);
                }
            } else {
                entry.setValue(omNode);
            }
            if (expiredValue != null) {
                if (expiredValue instanceof SequenceMediator) {
                    ((SequenceMediator)expiredValue).destroy();
                } else if (expiredValue instanceof Endpoint) {
                    ((Endpoint)expiredValue).destroy();
                }
            }
            entry.setVersion(re.getVersion());
        }
        if (re.getCachableDuration() > 0L) {
            entry.setExpiryTime(System.currentTimeMillis() + re.getCachableDuration());
        } else {
            entry.setExpiryTime(-1L);
        }
        return entry.getValue();
    }

    private void onError() {
        ++this.currentFailedCount;
        if (this.state == State.SUSPECT) {
            if (this.currentFailedCount == this.suspendThreshold) {
                log.info((Object)("Registry fetching state moved to :" + (Object)((Object)State.BACK_OFF) + " Registry is no longer available & Cached values will be used"));
                this.state = State.BACK_OFF;
                this.executionCount = 0;
                this.nextSuspendExecutionCount = 1;
            }
        } else if (this.state == State.BACK_OFF) {
            if (this.executionCount >= this.maxSuspendThreshold) {
                log.info((Object)("Registry fetching state moved to :" + (Object)((Object)State.SUSPENDED) + " Will be retried in another " + this.maxSuspendThreshold));
                this.state = State.SUSPENDED;
                this.executionCount = 0;
                this.nextSuspendExecutionCount = 1;
            }
        } else if (this.state == State.SUSPENDED) {
            this.state = State.SUSPENDED;
            this.executionCount = 0;
        } else if (this.state == State.ACTIVE) {
            log.info((Object)("Registry fetching state moved to :" + (Object)((Object)State.SUSPECT) + " Registry seems to be no longer available & Cached values will be used"));
            this.state = State.SUSPECT;
        }
    }

    private void onSuccess() {
        this.currentFailedCount = 0;
        if (this.state != State.ACTIVE) {
            log.info((Object)("Registry state changed from: " + (Object)((Object)this.state) + " " + (Object)((Object)State.ACTIVE)));
        }
        this.state = State.ACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(State state) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            if (state == State.ACTIVE) {
                this.currentFailedCount = 0;
                this.executionCount = 0;
                this.nextSuspendExecutionCount = 1;
                this.lastExecutionTime = 0L;
            } else if (state == State.SUSPENDED) {
                this.currentFailedCount = 0;
                this.executionCount = 0;
                this.nextSuspendExecutionCount = 0;
            }
            this.state = state;
        }
        finally {
            writeLock.unlock();
        }
    }

    public State getState() {
        return this.state;
    }

    public void reset() {
        log.info((Object)"Reset the state to the initial values");
        this.state = State.ACTIVE;
        this.currentFailedCount = 0;
        this.executionCount = 0;
        this.nextSuspendExecutionCount = 1;
        this.lastExecutionTime = 0L;
    }

    private class RegistryResourceEntry {
        private String path;
        private String type;

        private RegistryResourceEntry(String path, String type) {
            this.path = path;
            this.type = type;
        }

        public String getPath() {
            return this.path;
        }

        public String getType() {
            return this.type;
        }
    }
}

