/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.description.AxisDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.statistics.StatisticsRecord;
import org.apache.synapse.aspects.statistics.StatisticsRecordFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.config.BaseConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;

public class MessageHelper {
    private static Log log = LogFactory.getLog(MessageHelper.class);

    public static MessageContext cloneMessageContext(MessageContext synCtx) throws AxisFault {
        MessageContext newCtx = synCtx.getEnvironment().createMessageContext();
        Axis2MessageContext axis2MC = (Axis2MessageContext)newCtx;
        axis2MC.setAxis2MessageContext(MessageHelper.cloneAxis2MessageContext(((Axis2MessageContext)synCtx).getAxis2MessageContext()));
        newCtx.setConfiguration(synCtx.getConfiguration());
        newCtx.setEnvironment(synCtx.getEnvironment());
        newCtx.setContextEntries(synCtx.getContextEntries());
        newCtx.setProperty("aggregateCorelation", synCtx.getMessageID());
        newCtx.setTo(synCtx.getTo());
        newCtx.setReplyTo(synCtx.getReplyTo());
        newCtx.setSoapAction(synCtx.getSoapAction());
        newCtx.setWSAAction(synCtx.getWSAAction());
        newCtx.setResponse(synCtx.isResponse());
        for (Object o : synCtx.getPropertyKeySet()) {
            if (!(o instanceof String)) continue;
            if (synCtx.getProperty((String)o) != null && synCtx.getProperty((String)o) instanceof StatisticsRecord) {
                StatisticsRecord record = StatisticsRecordFactory.getStatisticsRecord(synCtx);
                newCtx.setProperty("synapse.statistics.stack", record);
                continue;
            }
            newCtx.setProperty((String)o, synCtx.getProperty((String)o));
        }
        Stack<FaultHandler> faultStack = synCtx.getFaultStack();
        if (!faultStack.isEmpty()) {
            ArrayList<FaultHandler> newFaultStack = new ArrayList<FaultHandler>();
            newFaultStack.addAll(faultStack);
            for (FaultHandler faultHandler : newFaultStack) {
                if (faultHandler == null) continue;
                newCtx.pushFaultHandler(faultHandler);
            }
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("Parent's Fault Stack : " + faultStack + " : Child's Fault Stack :" + newCtx.getFaultStack()));
        }
        return newCtx;
    }

    public static org.apache.axis2.context.MessageContext cloneAxis2MessageContext(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        NHttpServerConnection conn;
        org.apache.axis2.context.MessageContext newMC = MessageHelper.clonePartially(mc);
        newMC.setEnvelope(MessageHelper.cloneSOAPEnvelope(mc.getEnvelope()));
        newMC.setOptions(MessageHelper.cloneOptions(mc.getOptions()));
        newMC.setServiceContext(mc.getServiceContext());
        newMC.setOperationContext(mc.getOperationContext());
        newMC.setAxisMessage(mc.getAxisMessage());
        if (newMC.getAxisMessage() != null) {
            newMC.getAxisMessage().setParent((AxisDescription)mc.getAxisOperation());
        }
        newMC.setAxisService(mc.getAxisService());
        newMC.setTransportIn(mc.getTransportIn());
        newMC.setTransportOut(mc.getTransportOut());
        newMC.setProperty("OutTransportInfo", mc.getProperty("OutTransportInfo"));
        newMC.setProperty("TRANSPORT_HEADERS", (Object)MessageHelper.getClonedTransportHeaders(mc));
        if (newMC.getProperty("pass-through.pipe") != null && (conn = (NHttpServerConnection)newMC.getProperty("pass-through.Source-Connection")) != null) {
            SourceConfiguration sourceConfiguration = (SourceConfiguration)newMC.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
            Pipe pipe = new Pipe((IOControl)conn, sourceConfiguration.getBufferFactory().getBuffer(), "source", (BaseConfiguration)sourceConfiguration);
            newMC.setProperty("pass-through.pipe", (Object)pipe);
        }
        return newMC;
    }

    public static Map getClonedTransportHeaders(org.apache.axis2.context.MessageContext msgCtx) {
        Map headers = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        AbstractMap clonedHeaders = headers instanceof TreeMap ? new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        }) : new HashMap();
        if (headers != null && !headers.isEmpty()) {
            for (Object o : headers.keySet()) {
                String headerName = (String)o;
                clonedHeaders.put(headerName, headers.get(headerName));
            }
        }
        return clonedHeaders;
    }

    public static org.apache.axis2.context.MessageContext clonePartially(org.apache.axis2.context.MessageContext ori) throws AxisFault {
        org.apache.axis2.context.MessageContext newMC = new org.apache.axis2.context.MessageContext();
        newMC.setConfigurationContext(ori.getConfigurationContext());
        newMC.setMessageID(UIDGenerator.generateURNString());
        newMC.setTo(ori.getTo());
        newMC.setSoapAction(ori.getSoapAction());
        newMC.setProperty("CHARACTER_SET_ENCODING", ori.getProperty("CHARACTER_SET_ENCODING"));
        newMC.setProperty("enableMTOM", ori.getProperty("enableMTOM"));
        newMC.setProperty("enableSwA", ori.getProperty("enableSwA"));
        newMC.setProperty("HTTP_METHOD", ori.getProperty("HTTP_METHOD"));
        newMC.setProperty("messageType", ori.getProperty("messageType"));
        newMC.setDoingREST(ori.isDoingREST());
        newMC.setDoingMTOM(ori.isDoingMTOM());
        newMC.setDoingSwA(ori.isDoingSwA());
        Attachments attachments = ori.getAttachmentMap();
        if (attachments != null && attachments.getAllContentIDs().length > 0) {
            String[] cIDs = attachments.getAllContentIDs();
            String soapPart = attachments.getSOAPPartContentID();
            for (String cID : cIDs) {
                if (cID.equals(soapPart)) continue;
                newMC.addAttachment(cID, attachments.getDataHandler(cID));
            }
        }
        Iterator itr = ori.getPropertyNames();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (key == null) continue;
            newMC.setNonReplicableProperty(key, ori.getPropertyNonReplicable(key));
        }
        newMC.setServerSide(false);
        return newMC;
    }

    public static SOAPEnvelope cloneSOAPEnvelope(SOAPEnvelope envelope) {
        SOAPFactory fac = "http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope newEnvelope = fac.getDefaultEnvelope();
        if (envelope.getHeader() != null) {
            Iterator itr = envelope.getHeader().cloneOMElement().getChildren();
            while (itr.hasNext()) {
                OMNode node = (OMNode)itr.next();
                itr.remove();
                newEnvelope.getHeader().addChild(node);
            }
        }
        if (envelope.getBody() != null) {
            if (envelope.getBody().hasFault()) {
                SOAPFault fault = envelope.getBody().getFault();
                newEnvelope.getBody().addFault(MessageHelper.cloneSOAPFault(fault));
            } else {
                OMElement body = envelope.getBody().cloneOMElement();
                Iterator ns = body.getAllDeclaredNamespaces();
                OMNamespace bodyNs = body.getNamespace();
                String nsUri = bodyNs.getNamespaceURI();
                String nsPrefix = bodyNs.getPrefix();
                while (ns.hasNext()) {
                    OMNamespace namespace = (OMNamespace)ns.next();
                    if (nsUri != null && !nsUri.equals(namespace.getNamespaceURI()) && nsPrefix != null && !nsPrefix.equals(namespace.getPrefix())) {
                        newEnvelope.getBody().declareNamespace(namespace);
                    }
                    ns.remove();
                }
                Iterator attributes = body.getAllAttributes();
                while (attributes.hasNext()) {
                    OMAttribute attrb = (OMAttribute)attributes.next();
                    newEnvelope.getBody().addAttribute(attrb);
                    attributes.remove();
                }
                Iterator itr = body.getChildren();
                while (itr.hasNext()) {
                    OMNode node = (OMNode)itr.next();
                    itr.remove();
                    newEnvelope.getBody().addChild(node);
                }
            }
        }
        return newEnvelope;
    }

    public static Options cloneOptions(Options options) {
        Options clonedOptions = new Options(options.getParent());
        clonedOptions.setCallTransportCleanup(options.isCallTransportCleanup());
        clonedOptions.setExceptionToBeThrownOnSOAPFault(options.isExceptionToBeThrownOnSOAPFault());
        clonedOptions.setManageSession(options.isManageSession());
        clonedOptions.setSoapVersionURI(options.getSoapVersionURI());
        clonedOptions.setTimeOutInMilliSeconds(options.getTimeOutInMilliSeconds());
        clonedOptions.setUseSeparateListener(options.isUseSeparateListener());
        clonedOptions.setListener(options.getListener());
        clonedOptions.setTransportIn(options.getTransportIn());
        clonedOptions.setTransportInProtocol(options.getTransportInProtocol());
        clonedOptions.setTransportOut(options.getTransportOut());
        clonedOptions.setUserName(options.getUserName());
        clonedOptions.setPassword(options.getPassword());
        Iterator i$ = options.getProperties().keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String key = o = (String)i$.next();
            clonedOptions.setProperty(key, options.getProperty(key));
        }
        return clonedOptions;
    }

    public static SOAPEnvelope removeAddressingHeaders(org.apache.axis2.context.MessageContext axisMsgCtx) {
        SOAPEnvelope env = axisMsgCtx.getEnvelope();
        SOAPHeader soapHeader = env.getHeader();
        if (soapHeader != null) {
            ArrayList addressingHeaders = soapHeader.getHeaderBlocksWithNSURI("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            if (addressingHeaders != null && addressingHeaders.size() != 0) {
                MessageHelper.detachAddressingInformation(addressingHeaders);
            } else {
                addressingHeaders = soapHeader.getHeaderBlocksWithNSURI("http://www.w3.org/2005/08/addressing");
                if (addressingHeaders != null && addressingHeaders.size() != 0) {
                    MessageHelper.detachAddressingInformation(addressingHeaders);
                }
            }
        }
        return env;
    }

    private static void detachAddressingInformation(ArrayList headerInformation) {
        for (Object o : headerInformation) {
            OMElement om;
            OMNamespace ns;
            if (o instanceof SOAPHeaderBlock) {
                SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)o;
                headerBlock.detach();
                continue;
            }
            if (!(o instanceof OMElement) || (ns = (om = (OMElement)o).getNamespace()) == null || !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(ns.getNamespaceURI()) && !"http://www.w3.org/2005/08/addressing".equals(ns.getNamespaceURI())) continue;
            om.detach();
        }
    }

    public static Policy getPolicy(MessageContext synCtx, String propertyKey) {
        Object property = synCtx.getEntry(propertyKey);
        if (property != null && property instanceof OMElement) {
            return PolicyEngine.getPolicy((OMElement)((OMElement)property));
        }
        MessageHelper.handleException("Cannot locate policy from the property : " + propertyKey);
        return null;
    }

    public static SOAPFault cloneSOAPFault(SOAPFault fault) {
        int soapVersion;
        SOAPFactory fac;
        boolean SOAP_11 = true;
        int SOAP_12 = 2;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(fault.getNamespace().getNamespaceURI())) {
            fac = OMAbstractFactory.getSOAP11Factory();
            soapVersion = 1;
        } else {
            fac = OMAbstractFactory.getSOAP12Factory();
            soapVersion = 2;
        }
        SOAPFault newFault = fac.createSOAPFault();
        SOAPFaultCode code = fac.createSOAPFaultCode();
        SOAPFaultReason reason = fac.createSOAPFaultReason();
        switch (soapVersion) {
            case 1: {
                code.setText(fault.getCode().getTextAsQName());
                reason.setText(fault.getReason().getText());
                break;
            }
            case 2: {
                SOAPFaultValue value = fac.createSOAPFaultValue(code);
                value.setText(fault.getCode().getTextAsQName());
                for (Object obj : fault.getReason().getAllSoapTexts()) {
                    SOAPFaultText text = fac.createSOAPFaultText();
                    text.setText(((SOAPFaultText)obj).getText());
                    reason.addSOAPText(text);
                }
                break;
            }
        }
        newFault.setCode(code);
        newFault.setReason(reason);
        if (fault.getNode() != null) {
            SOAPFaultNode soapfaultNode = fac.createSOAPFaultNode();
            soapfaultNode.setNodeValue(fault.getNode().getNodeValue());
            newFault.setNode(soapfaultNode);
        }
        if (fault.getRole() != null) {
            SOAPFaultRole soapFaultRole = fac.createSOAPFaultRole();
            soapFaultRole.setRoleValue(fault.getRole().getRoleValue());
            newFault.setRole(soapFaultRole);
        }
        if (fault.getDetail() != null) {
            SOAPFaultDetail soapFaultDetail = fac.createSOAPFaultDetail();
            Iterator itr = fault.getDetail().getAllDetailEntries();
            while (itr.hasNext()) {
                Object element = itr.next();
                if (!(element instanceof OMElement)) continue;
                soapFaultDetail.addDetailEntry(((OMElement)element).cloneOMElement());
            }
            newFault.setDetail(soapFaultDetail);
        }
        return newFault;
    }

    public static void removeProcessedHeaders(org.apache.axis2.context.MessageContext axisMsgCtx, boolean preserveAddressing) {
        SOAPEnvelope env = axisMsgCtx.getEnvelope();
        SOAPHeader soapHeader = env.getHeader();
        if (soapHeader != null) {
            Iterator it = soapHeader.getChildElements();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SOAPHeaderBlock)) continue;
                SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)o;
                if (!preserveAddressing) {
                    if (!headerBlock.isProcessed()) continue;
                    headerBlock.detach();
                    continue;
                }
                if (MessageHelper.isAddressingHeader(headerBlock) || !headerBlock.isProcessed()) continue;
                headerBlock.detach();
            }
        }
    }

    private static boolean isAddressingHeader(SOAPHeaderBlock headerBlock) {
        OMNamespace ns = headerBlock.getNamespace();
        return ns != null && ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(ns.getNamespaceURI()) || "http://www.w3.org/2005/08/addressing".equals(ns.getNamespaceURI()));
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

