/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.streaming_xpath;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.antlr.runtime.RecognitionException;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.util.streaming_xpath.compiler.StreamingXPATHCompiler;
import org.apache.synapse.util.streaming_xpath.custom.StreamingParser;
import org.apache.synapse.util.streaming_xpath.exception.StreamingXPATHException;

public class StreamingXPATH {
    private String xPath;
    private StreamingParser streamingParser;

    public StreamingXPATH(String xPath) throws StreamingXPATHException {
        this.setxPath(xPath);
        try {
            this.setStreamingParser(StreamingXPATHCompiler.parse(this.getxPath()));
            if (this.streamingParser.getFirstComp() == null) {
                throw new StreamingXPATHException();
            }
        }
        catch (RecognitionException e) {
            throw new StreamingXPATHException(e);
        }
    }

    public String getStringValue(InputStream inputStream) throws XMLStreamException, StreamingXPATHException {
        if (this.streamingParser != null) {
            return this.getStreamingParser().process(inputStream);
        }
        return null;
    }

    public String getStringValue(OMElement documentElement) throws XMLStreamException, StreamingXPATHException {
        if (this.streamingParser != null) {
            return this.getStreamingParser().process(documentElement);
        }
        return null;
    }

    public String getxPath() {
        return this.xPath;
    }

    public void setxPath(String xPath) {
        this.xPath = xPath;
    }

    public StreamingParser getStreamingParser() {
        return this.streamingParser;
    }

    public void setStreamingParser(StreamingParser streamingParser) {
        this.streamingParser = streamingParser;
    }
}

