/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.streaming_xpath.custom;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.synapse.util.streaming_xpath.custom.components.GetAttributeParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetChildrenByNameParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetChildrenByNameRelativeParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetChildrenWithAttributeParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetChildrenWithAttributeValueParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetChildrenWithChildParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetChildrenWithChildValueParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetCurrentMatchParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetCurrentParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.GetFirstChildParserComponent;
import org.apache.synapse.util.streaming_xpath.custom.components.ParserComponent;

public class StreamingParser {
    ParserComponent firstComp;
    ParserComponent currentComp;

    public ParserComponent getCurrentComp() {
        return this.currentComp;
    }

    public void setCurrentComp(ParserComponent currentComp) {
        this.currentComp = currentComp;
    }

    public String process(InputStream xmlIn) throws XMLStreamException {
        StAXOMBuilder builder = new StAXOMBuilder(xmlIn);
        OMElement documentElement = builder.getDocumentElement();
        return this.firstComp.process(documentElement);
    }

    public String process(OMElement documentElement) throws XMLStreamException {
        return this.firstComp.process(documentElement);
    }

    public StreamingParser GetChild_GetCurrent() {
        GetCurrentParserComponent newComp = new GetCurrentParserComponent();
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
            this.currentComp = newComp;
        }
        return this;
    }

    public StreamingParser GetChild_GetCurrentMatch(String localName, String nameSpace) {
        GetCurrentMatchParserComponent newComp = new GetCurrentMatchParserComponent(localName, nameSpace);
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
            this.currentComp = newComp;
        }
        return this;
    }

    public StreamingParser GetChild_FirstChild() {
        GetFirstChildParserComponent newComp = new GetFirstChildParserComponent();
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
            this.currentComp = newComp;
        }
        return this;
    }

    public StreamingParser GetChild_GetChildrenByName(String localName, String nameSpace) {
        GetChildrenByNameParserComponent newComp = new GetChildrenByNameParserComponent(localName, nameSpace);
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
            this.currentComp = newComp;
        }
        return this;
    }

    public StreamingParser GetChild_GetChildrenByNameRelative(String localName, String nameSpace) {
        GetChildrenByNameRelativeParserComponent newComp = new GetChildrenByNameRelativeParserComponent(localName, nameSpace);
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
            this.currentComp = newComp;
        }
        return this;
    }

    public StreamingParser GetChild_GetChildrenWithChild(String localName, String nameSpace) {
        GetChildrenWithChildParserComponent newComp = new GetChildrenWithChildParserComponent(localName, nameSpace);
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
        }
        return this;
    }

    public StreamingParser GetChild_GetChildrenWithChildValue(String localName, String nameSpace, String value) {
        GetChildrenWithChildValueParserComponent newComp = new GetChildrenWithChildValueParserComponent(localName, nameSpace, value);
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
        }
        return this;
    }

    public StreamingParser GetChild_GetChildrenWithAttribute(String localName, String nameSpace) {
        GetChildrenWithAttributeParserComponent newComp = new GetChildrenWithAttributeParserComponent(localName, nameSpace);
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
        }
        return this;
    }

    public StreamingParser GetChild_GetChildrenWithAttributeValue(String localName, String nameSpace, String value) {
        GetChildrenWithAttributeValueParserComponent newComp = new GetChildrenWithAttributeValueParserComponent(localName, nameSpace, value);
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
        }
        return this;
    }

    public StreamingParser GetChild_GetAttribute(String localName, String nameSpace) {
        GetAttributeParserComponent newComp = new GetAttributeParserComponent(localName, nameSpace);
        if (this.firstComp == null) {
            this.firstComp = newComp;
            this.currentComp = newComp;
        } else {
            this.currentComp.setNext(newComp);
        }
        return this;
    }

    public ParserComponent getFirstComp() {
        return this.firstComp;
    }

    public void processOM(OMElement om) {
        this.firstComp.process(om);
    }
}

