/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class Base64EncodeFunction
implements Function {
    private static final Log log = LogFactory.getLog(Base64EncodeFunction.class);
    public static final String NULL_STRING = "";
    private static final String DEFAULT_CHARSET = "UTF-8";

    public Object call(Context context, List args) throws FunctionCallException {
        boolean debugOn = log.isDebugEnabled();
        if (args == null || args.size() == 0) {
            if (debugOn) {
                log.debug((Object)"Property key value for lookup is not specified");
            }
            return NULL_STRING;
        }
        int size = args.size();
        if (size == 1) {
            String value = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            return this.encode(debugOn, DEFAULT_CHARSET, value);
        }
        if (size == 2) {
            String value = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            String encoding = StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator());
            return this.encode(debugOn, encoding, value);
        }
        if (debugOn) {
            log.debug((Object)"base64Encode function expects only one argument, returning empty string");
        }
        return NULL_STRING;
    }

    private Object encode(boolean debugOn, String encoding, String value) throws FunctionCallException {
        String encodedString;
        byte[] encodedValue;
        if (value == null || NULL_STRING.equals(value)) {
            if (debugOn) {
                log.debug((Object)"Non emprty string value should be provided for encoding");
            }
            return NULL_STRING;
        }
        try {
            encodedValue = new Base64().encode(value.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unsupported Encoding";
            log.error((Object)msg, (Throwable)e);
            throw new FunctionCallException(msg, (Exception)e);
        }
        try {
            encodedString = new String(encodedValue, encoding).trim();
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unsupported Encoding";
            log.error((Object)msg, (Throwable)e);
            throw new FunctionCallException(msg, (Exception)e);
        }
        if (debugOn) {
            log.debug((Object)("Converted string: " + value + " with encoding: " + encoding + " to base64 encoded value: " + encodedString));
        }
        return encodedString;
    }
}

