/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath.ext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.util.xpath.ext.SynapseXpathFunctionContextProvider;
import org.apache.synapse.util.xpath.ext.SynapseXpathVariableResolver;
import org.jaxen.Function;

public class XpathExtensionUtil {
    private static final String SYNAPSE_XPATH_VARIABLE_EXTENSIONS = "synapse.xpath.var.extensions";
    private static final String SYNAPSE_XPATH_FUNCTION_EXTENSIONS = "synapse.xpath.func.extensions";
    private static final Log log = LogFactory.getLog(XpathExtensionUtil.class);

    public static List<SynapseXpathVariableResolver> getRegisteredVariableExtensions() {
        Properties synapseProps = SynapsePropertiesLoader.loadSynapseProperties();
        String propValue = synapseProps.getProperty(SYNAPSE_XPATH_VARIABLE_EXTENSIONS);
        ArrayList<SynapseXpathVariableResolver> extProviders = new ArrayList<SynapseXpathVariableResolver>();
        XpathExtensionUtil.extractProviders(propValue, extProviders);
        return extProviders;
    }

    public static List<SynapseXpathFunctionContextProvider> getRegisteredFunctionExtensions() {
        Properties synapseProps = SynapsePropertiesLoader.loadSynapseProperties();
        String propValue = synapseProps.getProperty(SYNAPSE_XPATH_FUNCTION_EXTENSIONS);
        ArrayList<SynapseXpathFunctionContextProvider> extProviders = new ArrayList<SynapseXpathFunctionContextProvider>();
        XpathExtensionUtil.extractProviders(propValue, extProviders);
        return extProviders;
    }

    private static <T> void extractProviders(String propValue, List<T> extProviders) {
        if (propValue != null) {
            String[] observerNames;
            for (String observer : observerNames = propValue.split(",")) {
                try {
                    Class<?> clazz = XpathExtensionUtil.class.getClassLoader().loadClass(observer.trim());
                    Object obj = clazz.newInstance();
                    extProviders.add(obj);
                }
                catch (Exception e) {
                    XpathExtensionUtil.handleException("Error while initializing Synapse Xpath extension providers", e);
                }
            }
        }
    }

    public static Function getFunctionContext(MessageContext ctxt, String namespaceURI, String prefix, String localName) {
        Map<QName, SynapseXpathFunctionContextProvider> extensions;
        SynapseXpathFunctionContextProvider functionContextProvider;
        SynapseEnvironment environment = ctxt.getEnvironment();
        if (environment != null && (functionContextProvider = XpathExtensionUtil.getMatchingExtensionProvider(extensions = environment.getXpathFunctionExtensions(), namespaceURI, prefix, localName)) != null) {
            return XpathExtensionUtil.initAndReturnXpathFunction(functionContextProvider, ctxt);
        }
        return null;
    }

    public static Object resolveVariableContext(MessageContext ctxt, String namespaceURI, String prefix, String localName) {
        Map<QName, SynapseXpathVariableResolver> extensions;
        SynapseXpathVariableResolver variableResolver;
        SynapseEnvironment environment = ctxt.getEnvironment();
        if (environment != null && (variableResolver = XpathExtensionUtil.getMatchingExtensionProvider(extensions = environment.getXpathVariableExtensions(), namespaceURI, prefix, localName)) != null) {
            return XpathExtensionUtil.resolveXpathVariable(variableResolver, ctxt);
        }
        return null;
    }

    private static <T> T getMatchingExtensionProvider(Map<QName, T> extensionMap, String namespaceURI, String prefix, String localName) {
        QName subject;
        if (localName != null && prefix != null) {
            subject = new QName(namespaceURI, localName, prefix);
        } else if (localName != null) {
            subject = new QName(namespaceURI, localName);
        } else {
            return null;
        }
        Set<QName> qNames = extensionMap.keySet();
        for (QName qName : qNames) {
            if (!subject.equals(qName)) continue;
            return extensionMap.get(qName);
        }
        return null;
    }

    private static Object resolveXpathVariable(SynapseXpathVariableResolver variableExt, MessageContext ctxt) {
        try {
            return variableExt.resolve(ctxt);
        }
        catch (Exception e) {
            XpathExtensionUtil.handleExceptionWarning("Error Invoking Xpath Variable Provider " + variableExt.getClass().getName(), e);
            return null;
        }
    }

    private static Function initAndReturnXpathFunction(SynapseXpathFunctionContextProvider funcExtProvider, MessageContext ctxt) {
        try {
            return funcExtProvider.getInitializedExtFunction(ctxt);
        }
        catch (Exception e) {
            XpathExtensionUtil.handleExceptionWarning("Error Initializing Xpath Function Provider " + funcExtProvider.getClass().getName(), e);
            return null;
        }
    }

    private static void handleException(String msg, Exception e) {
        log.warn((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static void handleExceptionWarning(String msg, Exception e) {
        log.warn((Object)msg, (Throwable)e);
    }
}

