/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import com.jezhumble.javasysmon.NativeLibraryLoader;
import com.jezhumble.javasysmon.ProcessInfo;

class MacOsXMonitor
implements Monitor {
    private static Monitor monitor = null;

    public MacOsXMonitor() {
        JavaSysMon.addSupportedConfig("Mac Os X (PPC, x86, X86_64)");
        if (monitor != null) {
            JavaSysMon.setMonitor(monitor);
        }
    }

    public String osName() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public native int numCpus();

    public native long cpuFrequencyInHz();

    public native long uptimeInSeconds();

    public native int currentPid();

    public native CpuTimes cpuTimes();

    public native MemoryStats physical();

    public native MemoryStats swap();

    public native ProcessInfo[] processTable();

    public native void killProcess(int var1);

    static {
        if (System.getProperty("os.name").toLowerCase().equals("mac os x")) {
            new NativeLibraryLoader().loadLibrary("libjavasysmon.jnilib");
            monitor = new MacOsXMonitor();
        }
    }
}

