/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.component.xml.builder;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.utils.component.xml.builder.ComponentConfigBuilder;
import org.wso2.carbon.utils.component.xml.config.ComponentConfig;
import org.wso2.carbon.utils.component.xml.config.ManagementPermission;

public class ManagementPermissionsBuilder
extends ComponentConfigBuilder {
    public static final String LOCALNAME_MGT_PERMISSIONS = "ManagementPermissions";
    public static final String LOCALNAME_MGT_PERMISSION = "ManagementPermission";
    public static final String LOCALNAME_DISPLAY_NAME = "DisplayName";
    public static final String LOCALNAME_RESOURCE_ID = "ResourceId";

    @Override
    public ComponentConfig[] build(OMElement omElement) throws CarbonException {
        ArrayList<ManagementPermission> permissionList = new ArrayList<ManagementPermission>();
        Iterator iterator = omElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", LOCALNAME_MGT_PERMISSION));
        while (iterator.hasNext()) {
            OMElement configElement = (OMElement)iterator.next();
            OMElement displayNameElement = configElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", LOCALNAME_DISPLAY_NAME));
            String name = null;
            if (displayNameElement != null) {
                name = displayNameElement.getText().trim();
            }
            if (name == null) {
                throw new CarbonException("Mandatory attribute DisplayName does not exist or is empty in the component.xml");
            }
            OMElement resourceIdElement = configElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", LOCALNAME_RESOURCE_ID));
            String resourceId = null;
            if (resourceIdElement != null) {
                resourceId = resourceIdElement.getText().trim();
            }
            if (resourceId == null) {
                throw new CarbonException("Mandatory attribute EJBApplicationServer/Name entry does not exist or is empty in the component.xml");
            }
            ManagementPermission uiPermission = new ManagementPermission(name, resourceId);
            permissionList.add(uiPermission);
        }
        if (permissionList.size() == 0) {
            return null;
        }
        ManagementPermission[] uiPermissions = new ManagementPermission[permissionList.size()];
        return permissionList.toArray(uiPermissions);
    }

    @Override
    public String getLocalNameOfComponentConfigElement() {
        return LOCALNAME_MGT_PERMISSIONS;
    }
}

