/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.dom.DOMWriter;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMObjectModel
implements ExternalObjectModel,
Serializable {
    public boolean isRecognizedNode(Object object) {
        return object instanceof Node && !(object instanceof NodeOverNodeInfo);
    }

    public boolean isRecognizedNodeClass(Class clazz) {
        return Node.class.isAssignableFrom(clazz) && !NodeOverNodeInfo.class.isAssignableFrom(clazz);
    }

    public boolean isRecognizedNodeListClass(Class clazz) {
        return NodeList.class.isAssignableFrom(clazz);
    }

    public Receiver getDocumentBuilder(Result result) throws XPathException {
        if (result instanceof DOMResult) {
            DOMWriter dOMWriter = new DOMWriter();
            Node node = ((DOMResult)result).getNode();
            if (node == null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    ((DOMResult)result).setNode(document);
                    dOMWriter.setNode(document);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new DynamicError(parserConfigurationException);
                }
            } else {
                dOMWriter.setNode(node);
            }
            return dOMWriter;
        }
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipelineConfiguration) throws XPathException {
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            DOMSender dOMSender = new DOMSender();
            dOMSender.setStartNode(node);
            dOMSender.setReceiver(receiver);
            dOMSender.setPipelineConfiguration(pipelineConfiguration);
            dOMSender.setSystemId(source.getSystemId());
            dOMSender.send();
            return true;
        }
        return false;
    }

    public NodeInfo unravel(Source source, Configuration configuration) {
        Node node;
        if (source instanceof DOMSource && !((node = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo)) {
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            DocumentWrapper documentWrapper = new DocumentWrapper((Node)document, source.getSystemId(), configuration);
            return documentWrapper.wrap(node);
        }
        return null;
    }

    public NodeInfo wrapOrUnwrapNode(Node node, Configuration configuration) throws XPathException {
        if (node instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)node).getUnderlyingNodeInfo();
        }
        DocumentInfo documentInfo = this.wrapDocument(node, "", configuration);
        return this.wrapNode(documentInfo, node);
    }

    public Value convertObjectToXPathValue(Object object, Configuration configuration) throws XPathException {
        if (object instanceof NodeList && !(object instanceof Node)) {
            NodeList nodeList = (NodeList)object;
            int n = nodeList.getLength();
            Item[] itemArray = new NodeInfo[n];
            for (int i = 0; i < n; ++i) {
                if (nodeList.item(i) instanceof NodeOverNodeInfo) {
                    itemArray[i] = ((NodeOverNodeInfo)nodeList.item(i)).getUnderlyingNodeInfo();
                    continue;
                }
                DocumentInfo documentInfo = this.wrapDocument(nodeList.item(i), "", configuration);
                NodeInfo nodeInfo = this.wrapNode(documentInfo, nodeList.item(i));
                itemArray[i] = nodeInfo;
            }
            return new SequenceExtent(itemArray);
        }
        return null;
    }

    public Object convertXPathValueToObject(Value value, Class clazz, XPathContext xPathContext) throws XPathException {
        Object object;
        boolean bl;
        boolean bl2 = Node.class.isAssignableFrom(clazz) || clazz == NodeList.class || clazz.isArray() && Node.class.isAssignableFrom(clazz.getComponentType());
        boolean bl3 = clazz == Object.class || clazz.isAssignableFrom(ArrayList.class) || clazz.isAssignableFrom(HashSet.class) || clazz.isArray() && clazz.getComponentType() == Object.class ? true : (bl = false);
        if (!bl2 && !bl) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        SequenceIterator sequenceIterator = value.iterate();
        while ((object = sequenceIterator.next()) != null) {
            Object object2;
            if (object instanceof VirtualNode) {
                object2 = ((VirtualNode)object).getUnderlyingNode();
                if (object2 instanceof Node) {
                    arrayList.add(object2);
                    continue;
                }
                if (!bl2) continue;
                DynamicError dynamicError = new DynamicError("Extension function required class " + clazz.getName() + "; supplied value of class " + object.getClass().getName() + " could not be converted");
                throw dynamicError;
            }
            if (bl2) {
                if (object instanceof NodeInfo) {
                    arrayList.add(NodeOverNodeInfo.wrap((NodeInfo)object));
                    continue;
                }
                object2 = new DynamicError("Extension function required class " + clazz.getName() + "; supplied value of class " + object.getClass().getName() + " could not be converted");
                throw object2;
            }
            return null;
        }
        if (arrayList.size() == 0 && !bl2) {
            return null;
        }
        if (Node.class.isAssignableFrom(clazz)) {
            if (arrayList.size() != 1) {
                object = new DynamicError("Extension function requires a single DOM Node; supplied value contains " + arrayList.size() + " nodes");
                throw object;
            }
            return arrayList.get(0);
        }
        if (clazz == NodeList.class) {
            return new DOMNodeList(arrayList);
        }
        if (clazz.isArray() && clazz.getComponentType() == Node.class) {
            object = new Node[arrayList.size()];
            arrayList.toArray((T[])object);
            return object;
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return arrayList;
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet(arrayList);
        }
        return null;
    }

    public DocumentInfo wrapDocument(Object object, String string, Configuration configuration) {
        if (object instanceof DocumentOverNodeInfo) {
            return (DocumentInfo)((DocumentOverNodeInfo)object).getUnderlyingNodeInfo();
        }
        if (object instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)object).getUnderlyingNodeInfo().getDocumentRoot();
        }
        if (object instanceof Node) {
            if (((Node)object).getNodeType() == 9) {
                Document document = (Document)object;
                return new DocumentWrapper((Node)document, string, configuration);
            }
            if (((Node)object).getNodeType() == 11) {
                DocumentFragment documentFragment = (DocumentFragment)object;
                return new DocumentWrapper((Node)documentFragment, string, configuration);
            }
            Document document = ((Node)object).getOwnerDocument();
            return new DocumentWrapper((Node)document, string, configuration);
        }
        throw new IllegalArgumentException("Unknown node class " + object.getClass());
    }

    public NodeInfo wrapNode(DocumentInfo documentInfo, Object object) {
        return ((DocumentWrapper)documentInfo).wrap((Node)object);
    }

    public Object convertToNodeList(SequenceExtent sequenceExtent) {
        try {
            DOMNodeList dOMNodeList = DOMNodeList.checkAndMake(sequenceExtent);
            return dOMNodeList;
        }
        catch (XPathException xPathException) {
            return null;
        }
    }
}

