/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.javax.xml.xquery.XQCommonHandler;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemAccessor;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.javax.xml.xquery.XQWarning;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullToStax;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQItem;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQForwardSequence
implements XQResultSequence {
    private SequenceIterator iterator;
    private SaxonXQConnection connection;
    int position = 0;
    boolean closed = false;

    protected SaxonXQForwardSequence(SequenceIterator sequenceIterator, SaxonXQConnection saxonXQConnection) {
        this.iterator = sequenceIterator;
        this.connection = saxonXQConnection;
    }

    SequenceIterator getCleanIterator() throws XPathException {
        return this.iterator.getAnother();
    }

    public void clearWarnings() {
    }

    public XQConnection getConnection() {
        return this.connection;
    }

    public XQWarning getWarnings() {
        return null;
    }

    public String getAtomicValue() throws XQException {
        return this.getCurrentXQItem().getAtomicValue();
    }

    public boolean getBoolean() throws XQException {
        return this.getCurrentXQItem().getBoolean();
    }

    public byte getByte() throws XQException {
        return this.getCurrentXQItem().getByte();
    }

    public double getDouble() throws XQException {
        return this.getCurrentXQItem().getDouble();
    }

    public float getFloat() throws XQException {
        return this.getCurrentXQItem().getFloat();
    }

    public int getInt() throws XQException {
        return this.getCurrentXQItem().getInt();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getCurrentXQItem().getItemAsStream();
    }

    public String getItemAsString() throws XQException {
        return this.getCurrentXQItem().getItemAsString();
    }

    public XQItemType getItemType() throws XQException {
        return this.getCurrentXQItem().getItemType();
    }

    public long getLong() throws XQException {
        return this.getCurrentXQItem().getLong();
    }

    public Node getNode() throws XQException {
        return this.getCurrentXQItem().getNode();
    }

    public URI getNodeUri() throws XQException {
        return this.getCurrentXQItem().getNodeUri();
    }

    public Object getObject() throws XQException {
        return this.getCurrentXQItem().getObject();
    }

    public Object getObject(XQCommonHandler xQCommonHandler) throws XQException {
        return this.getCurrentXQItem().getObject(xQCommonHandler);
    }

    public short getShort() throws XQException {
        return this.getCurrentXQItem().getShort();
    }

    public boolean instanceOf(XQItemType xQItemType) throws XQException {
        return this.getCurrentXQItem().instanceOf(xQItemType);
    }

    public void writeItem(OutputStream outputStream, Properties properties) throws XQException {
        this.getCurrentXQItem().writeItem(outputStream, properties);
    }

    public void writeItem(Writer writer, Properties properties) throws XQException {
        this.getCurrentXQItem().writeItem(writer, properties);
    }

    public void writeItemToSAX(ContentHandler contentHandler) throws XQException {
        this.getCurrentXQItem().writeItemToSAX(contentHandler);
    }

    public boolean absolute(int n) throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public void afterLast() throws XQException {
        this.checkNotClosed();
        this.position = -1;
    }

    public void beforeFirst() throws XQException {
        this.checkNotClosed();
        try {
            this.iterator = this.iterator.getAnother();
            this.position = 0;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void close() throws XQException {
        this.closed = true;
        this.iterator = null;
        this.connection = null;
    }

    public int count() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean first() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public XQItem getItem() throws XQException {
        return new SaxonXQItem(this.iterator.current(), this.connection.getConfiguration());
    }

    public int getPosition() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public XMLStreamReader getSequenceAsStream() throws XQException {
        PullFromIterator pullFromIterator = new PullFromIterator(this.iterator);
        pullFromIterator.setPipelineConfiguration(this.connection.getConfiguration().makePipelineConfiguration());
        return new PullToStax(pullFromIterator);
    }

    public String getSequenceAsString(Properties properties) throws XQException {
        StringWriter stringWriter = new StringWriter();
        this.writeSequence(stringWriter, properties);
        return stringWriter.toString();
    }

    public boolean isAfterLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isBeforeFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isOnItem() throws XQException {
        this.checkNotClosed();
        return this.position > 0;
    }

    public boolean isScrollable() throws XQException {
        this.checkNotClosed();
        return false;
    }

    public boolean last() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean next() throws XQException {
        this.checkNotClosed();
        if (this.position < 0) {
            return false;
        }
        try {
            Item item = this.iterator.next();
            if (item == null) {
                this.position = -1;
                return false;
            }
            ++this.position;
            return true;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public boolean previous() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean relative(int n) throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public void writeSequence(OutputStream outputStream, Properties properties) throws XQException {
        this.checkNotClosed();
        try {
            QueryResult.serializeSequence(this.iterator, this.connection.getConfiguration(), outputStream, properties);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void writeSequence(Writer writer, Properties properties) throws XQException {
        this.checkNotClosed();
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        try {
            QueryResult.serializeSequence(this.iterator, this.connection.getConfiguration(), printWriter, properties);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void writeSequenceToSAX(ContentHandler contentHandler) throws XQException {
        this.checkNotClosed();
        if (this.position < 0) {
            return;
        }
        try {
            PipelineConfiguration pipelineConfiguration = this.connection.getConfiguration().makePipelineConfiguration();
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(contentHandler);
            contentHandlerProxy.setPipelineConfiguration(pipelineConfiguration);
            TreeReceiver treeReceiver = new TreeReceiver(contentHandlerProxy);
            treeReceiver.open();
            Item item = this.iterator.current();
            do {
                treeReceiver.append(item, 0, 2);
            } while ((item = this.iterator.next()) != null);
            treeReceiver.close();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    private XQItemAccessor getCurrentXQItem() throws XQException {
        this.checkNotClosed();
        if (this.position == 0) {
            throw new XQException("The XQSequence is positioned before the first item");
        }
        if (this.position < 0) {
            throw new XQException("The XQSequence is positioned after the last item");
        }
        return new SaxonXQItem(this.iterator.current(), this.connection.getConfiguration());
    }

    private void checkNotClosed() throws XQException {
        if (this.closed) {
            throw new XQException("The XQSequence has been closed");
        }
    }
}

