/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.util.Vector;
import javax.crypto.SecretKey;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.WSSecDerivedKeyBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecDKEncrypt
extends WSSecDerivedKeyBase {
    protected String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";

    public Document build(Document doc, WSSecHeader secHeader) throws WSSecurityException, ConversationException {
        this.prepare(doc);
        this.envelope = doc.getDocumentElement();
        this.prependDKElementToHeader(secHeader);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.envelope);
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Element externRefList = this.encryptForExternalRef(null, this.parts);
        this.addExternalRefElement(externRefList, secHeader);
        return doc;
    }

    private Vector doEncryption(Document doc, byte[] secretKey, Vector references) throws WSSecurityException {
        SecretKey key = WSSecurityUtil.prepareSecretKey(this.symEncAlgo, secretKey);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance(this.symEncAlgo);
        }
        catch (XMLEncryptionException e3) {
            throw new WSSecurityException(2, null, null, e3);
        }
        Vector<String> encDataRefs = new Vector<String>();
        if (this.envelope == null) {
            this.envelope = doc.getDocumentElement();
        }
        for (int part = 0; part < references.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)references.get(part);
            String idToEnc = encPart.getId();
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            String modifier = encPart.getEncModifier();
            Element body = null;
            if (idToEnc != null) {
                body = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToEnc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                if (body == null) {
                    body = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToEnc, null);
                }
            } else {
                body = (Element)WSSecurityUtil.findElement(this.envelope, elemName, nmSpace);
            }
            if (body == null) {
                throw new WSSecurityException(0, "noEncElement", new Object[]{"{" + nmSpace + "}" + elemName});
            }
            boolean content = modifier.equals("Content");
            String xencEncryptedDataId = this.wssConfig.getIdAllocator().createId("EncDataId-", body);
            try {
                KeyInfo keyInfo = new KeyInfo(this.document);
                SecurityTokenReference secToken = new SecurityTokenReference(this.document);
                Reference ref = new Reference(this.document);
                ref.setURI("#" + this.dktId);
                secToken.setReference(ref);
                keyInfo.addUnknownElement(secToken.getElement());
                Element keyInfoElement = keyInfo.getElement();
                keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
                xmlCipher.init(1, key);
                EncryptedData encData = xmlCipher.getEncryptedData();
                encData.setId(xencEncryptedDataId);
                encData.setKeyInfo(keyInfo);
                xmlCipher.doFinal(doc, body, content);
            }
            catch (Exception e2) {
                throw new WSSecurityException(9, null, null, e2);
            }
            encDataRefs.add("#" + xencEncryptedDataId);
        }
        return encDataRefs;
    }

    public Element encryptForExternalRef(Element dataRef, Vector references) throws WSSecurityException {
        Vector encDataRefs = this.doEncryption(this.document, this.derivedKeyBytes, references);
        Element referenceList = dataRef;
        if (referenceList == null) {
            referenceList = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        }
        WSSecDKEncrypt.createDataRefList(this.document, referenceList, encDataRefs);
        return referenceList;
    }

    public void addExternalRefElement(Element referenceList, WSSecHeader secHeader) {
        Node node = this.dkt.getElement().getNextSibling();
        if (node instanceof Element) {
            secHeader.getSecurityHeader().insertBefore(referenceList, node);
        } else {
            secHeader.getSecurityHeader().appendChild(referenceList);
        }
    }

    public static Element createDataRefList(Document doc, Element referenceList, Vector encDataRefs) {
        for (int i = 0; i < encDataRefs.size(); ++i) {
            String dataReferenceUri = (String)encDataRefs.get(i);
            Element dataReference = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataReference.setAttributeNS(null, "URI", dataReferenceUri);
            referenceList.appendChild(dataReference);
        }
        return referenceList;
    }

    public void setSymmetricEncAlgorithm(String algo) {
        this.symEncAlgo = algo;
    }

    @Override
    protected int getDerivedKeyLength() throws WSSecurityException {
        return this.derivedKeyLength > 0 ? this.derivedKeyLength : WSSecurityUtil.getKeyLength(this.symEncAlgo);
    }
}

