/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.SignatureConfirmation;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecSignatureConfirmation
extends WSSecBase {
    private static Log log = LogFactory.getLog((String)WSSecSignatureConfirmation.class.getName());
    private SignatureConfirmation sc = null;
    byte[] signatureValue = null;

    public void setSignatureValue(byte[] signatureValue) {
        this.signatureValue = signatureValue;
    }

    public void prepare(Document doc) {
        this.sc = new SignatureConfirmation(doc, this.signatureValue);
        this.sc.setID(this.wssConfig.getIdAllocator().createId("SigConf-", this.sc));
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.sc.getElement());
    }

    public Document build(Document doc, byte[] sigVal, WSSecHeader secHeader) {
        log.debug((Object)"Begin add signature confirmation...");
        this.signatureValue = sigVal;
        this.prepare(doc);
        this.prependToHeader(secHeader);
        return doc;
    }

    public String getId() {
        if (this.sc == null) {
            return null;
        }
        return this.sc.getID();
    }

    public Element getSignatureConfirmationElement() {
        return this.sc != null ? this.sc.getElement() : null;
    }
}

