/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.util.Loader;

public abstract class SAMLIssuerFactory {
    private static final Log log = LogFactory.getLog(SAMLIssuerFactory.class);
    private static final boolean doDebug = log.isDebugEnabled();
    private static final String defaultSAMLClassName = "org.apache.ws.security.saml.SAMLIssuerImpl";

    public static SAMLIssuer getInstance() {
        return SAMLIssuerFactory.getInstance("saml.properties");
    }

    public static SAMLIssuer getInstance(String samlClassName, Properties properties) {
        return SAMLIssuerFactory.loadClass(samlClassName, properties);
    }

    public static SAMLIssuer getInstance(String propFilename) {
        Properties properties = null;
        String samlClassName = null;
        if (samlClassName == null || samlClassName.length() == 0) {
            properties = SAMLIssuerFactory.getProperties(propFilename);
            samlClassName = properties.getProperty("org.apache.ws.security.saml.issuerClass", defaultSAMLClassName);
        }
        return SAMLIssuerFactory.loadClass(samlClassName, properties);
    }

    private static SAMLIssuer loadClass(String samlClassName, Properties properties) {
        Class samlIssuerClass = null;
        SAMLIssuer samlIssuer = null;
        try {
            samlIssuerClass = Loader.loadClass(samlClassName);
        }
        catch (ClassNotFoundException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new RuntimeException(samlClassName + " Not Found", ex);
        }
        log.info((Object)("Using Crypto Engine [" + samlClassName + "]"));
        try {
            Class[] classes = new Class[]{Properties.class};
            Constructor c = samlIssuerClass.getConstructor(classes);
            samlIssuer = (SAMLIssuer)c.newInstance(properties);
            return samlIssuer;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                samlIssuer = (SAMLIssuer)samlIssuerClass.newInstance();
                return samlIssuer;
            }
            catch (Exception ex2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)ex2.getMessage(), (Throwable)ex2);
                }
                throw new RuntimeException(samlClassName + " cannot create instance", ex2);
            }
        }
    }

    private static Properties getProperties(String propFilename) {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(propFilename);
            properties.load(url.openStream());
        }
        catch (Exception e) {
            if (doDebug) {
                log.debug((Object)("Cannot find SAML property file: " + propFilename), (Throwable)e);
            }
            throw new RuntimeException("SAMLIssuerFactory: Cannot load properties: " + propFilename, e);
        }
        return properties;
    }
}

