/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ModuleDeployer;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.deployment.CarbonDeploymentSchedulerTask;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.Axis2ConfigItemHolder;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ServerException;
import org.wso2.carbon.utils.deployment.Axis2DeployerRegistry;
import org.wso2.carbon.utils.deployment.Axis2ModuleRegistry;
import org.wso2.carbon.utils.deployment.GhostDeployerRegistry;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.deployment.service.listeners.Axis2ConfigServiceListener;

public class CarbonAxisConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private static Log log = LogFactory.getLog(CarbonAxisConfigurator.class);
    private Collection globallyEngagedModules = new ArrayList();
    private String axis2xml;
    private String repoLocation;
    private String webLocation;
    private boolean isInitialized;
    private boolean isUrlRepo;
    private boolean isUrlAxis2Xml;
    private Axis2ConfigServiceListener configServiceListener;
    private Axis2ConfigItemHolder configItemHolder;
    private File repositoryDir;
    private BundleContext bundleContext;
    private String carbonContextRoot;
    private ScheduledExecutorService scheduler;
    private CarbonDeploymentSchedulerTask schedulerTask;

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public Axis2ConfigItemHolder getConfigItemHolder() {
        return this.configItemHolder;
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public void setCarbonContextRoot(String carbonContextRoot) {
        this.carbonContextRoot = carbonContextRoot;
    }

    public void init(String repoLocation, String weblocation) throws ServerException {
        if (repoLocation == null) {
            throw new ServerException("Axis2 repository not specified!");
        }
        this.webLocation = weblocation;
        this.isUrlRepo = CarbonUtils.isURL((String)repoLocation);
        if (this.isUrlRepo) {
            try {
                new URL(repoLocation).openConnection().connect();
            }
            catch (IOException e) {
                throw new ServerException("Cannot connect to URL repository " + repoLocation, (Throwable)e);
            }
            this.repoLocation = repoLocation;
        } else {
            File repo = new File(repoLocation);
            if (repo.exists()) {
                this.repoLocation = repo.getAbsolutePath();
            } else {
                this.repoLocation = System.getProperty("wso2wsas.home") + File.separator + repoLocation;
                repo = new File(this.repoLocation);
                if (!repo.exists()) {
                    this.repoLocation = null;
                    throw new ServerException("Repository location '" + repoLocation + "' not found!");
                }
            }
        }
        this.axis2xml = CarbonUtils.getAxis2Xml();
        this.isUrlAxis2Xml = CarbonUtils.isURL((String)this.axis2xml);
        if (!this.isUrlAxis2Xml) {
            File configFile = new File(this.axis2xml);
            if (!configFile.exists()) {
                this.axis2xml = null;
            }
        } else {
            try {
                URLConnection urlConnection = new URL(this.axis2xml).openConnection();
                urlConnection.connect();
            }
            catch (IOException e) {
                throw new ServerException("Cannot connect to axis2.xml URL " + repoLocation, (Throwable)e);
            }
            this.isInitialized = true;
        }
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        File axis2ServicesDir;
        this.axisConfig = null;
        try {
            this.axisConfig = this.populateAxisConfiguration(this.getAxis2XmlInputStream());
        }
        catch (DeploymentException e) {
            throw new AxisFault("Exception occured while loading the Axis configuration from " + this.axis2xml, (Throwable)e);
        }
        this.axisConfig.setConfigurator((AxisConfigurator)this);
        if (this.bundleContext != null) {
            this.configServiceListener = new Axis2ConfigServiceListener(this.axisConfig, this.bundleContext);
        }
        if (GhostDeployerUtils.isGhostOn()) {
            new GhostDeployerRegistry(this.axisConfig).register(this.configItemHolder.getDeployerBundles());
        } else {
            new Axis2DeployerRegistry(this.axisConfig).register(this.configItemHolder.getDeployerBundles());
        }
        Axis2ModuleRegistry moduleRegistry = new Axis2ModuleRegistry(this.axisConfig);
        moduleRegistry.register(this.configItemHolder.getModuleBundles());
        this.globallyEngagedModules = this.axisConfig.getEngagedModules();
        if (this.repoLocation != null && this.repoLocation.trim().length() != 0) {
            try {
                if (this.isUrlRepo) {
                    URL axis2Repository = new URL(this.repoLocation);
                    this.axisConfig.setRepository(axis2Repository);
                    this.loadRepositoryFromURL(axis2Repository);
                }
                this.axisConfig.setRepository(new URL("file://" + this.repoLocation));
                this.loadRepository(this.repoLocation);
            }
            catch (MalformedURLException e) {
                throw new AxisFault("Invalid URL", (Throwable)e);
            }
        } else {
            this.loadFromClassPath();
        }
        if (GhostDeployerUtils.isGhostOn() && (axis2ServicesDir = new File(this.repoLocation, CarbonUtils.getAxis2ServicesDir((AxisConfiguration)this.axisConfig))).exists()) {
            this.axisConfig.setServiceClassLoader(Utils.getClassLoader((ClassLoader)this.axisConfig.getSystemClassLoader(), (File)axis2ServicesDir, (boolean)this.axisConfig.isChildFirstClassLoading()));
        }
        for (Object globallyEngagedModule : this.globallyEngagedModules) {
            AxisModule module = (AxisModule)globallyEngagedModule;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Globally engaging module: " + module.getName()));
        }
        if (this.carbonContextRoot != null) {
            Parameter contextRootParam = new Parameter("contextRoot", (Object)this.carbonContextRoot);
            this.axisConfig.addParameter(contextRootParam);
        }
        return this.axisConfig;
    }

    public boolean isGlobalyEngaged(AxisModule axisModule) {
        String modName = axisModule.getName();
        for (Object globallyEngagedModule : this.globallyEngagedModules) {
            AxisModule module = (AxisModule)globallyEngagedModule;
            if (!modName.startsWith(module.getName())) continue;
            return true;
        }
        return false;
    }

    public void engageGlobalModules() throws AxisFault {
        this.engageModules();
    }

    public AxisConfiguration populateAxisConfiguration(InputStream in) throws DeploymentException {
        this.axisConfig = new AxisConfiguration();
        if (this.repoLocation != null && this.repoLocation.trim().length() != 0) {
            try {
                if (this.isUrlRepo) {
                    URL axis2Repository = new URL(this.repoLocation);
                    this.axisConfig.setRepository(axis2Repository);
                } else {
                    this.axisConfig.setRepository(new URL("file://" + this.repoLocation));
                }
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Invalid URL " + this.repoLocation, (Throwable)e);
            }
        }
        try {
            RegistryService rs = CarbonCoreDataHolder.getInstance().getRegistryService();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getCurrentContext((AxisConfiguration)this.axisConfig);
            carbonContext.setRegistry(RegistryType.SYSTEM_CONFIGURATION, (Registry)rs.getConfigSystemRegistry());
            carbonContext.setRegistry(RegistryType.SYSTEM_GOVERNANCE, (Registry)rs.getGovernanceSystemRegistry());
            carbonContext.setRegistry(RegistryType.LOCAL_REPOSITORY, (Registry)rs.getLocalRepository());
            carbonContext.setTenantId(-1234);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
        }
        catch (Exception e) {
            String msg = "Error occurred while populating the CarbonContext on the AxisConfiguration";
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
        AxisConfigBuilder builder = new AxisConfigBuilder(in, this.axisConfig, (DeploymentEngine)this);
        builder.populateConfig();
        if (CarbonUtils.isChildNode()) {
            try {
                OMElement element = (OMElement)XMLUtils.toOM((InputStream)this.getAxis2XmlInputStream());
                Iterator trs_Reivers = element.getChildrenWithName(new QName("transportReceiver"));
                while (trs_Reivers.hasNext()) {
                    OMElement transport = (OMElement)trs_Reivers.next();
                    String transportType = transport.getAttributeValue(new QName("name"));
                    Iterator itr = transport.getChildrenWithName(new QName("parameter"));
                    while (itr.hasNext()) {
                        OMElement parameterElement = (OMElement)itr.next();
                        OMAttribute paramName = parameterElement.getAttribute(new QName("name"));
                        if (!"port".equals(paramName.getAttributeValue())) continue;
                        if ("http".equals(transportType)) {
                            parameterElement.setText(System.getProperty("niohttpPort"));
                            continue;
                        }
                        if (!"https".equals(transportType)) continue;
                        parameterElement.setText(System.getProperty("niohttpsPort"));
                    }
                }
                builder.processTransportReceivers(element.getChildrenWithName(new QName("transportReceiver")));
            }
            catch (Exception e) {
                log.error((Object)"Error Reading axis2.xml", (Throwable)e);
            }
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            String msg = "error in closing input stream";
            log.error((Object)msg);
        }
        try {
            this.loadTransports();
        }
        catch (Exception e) {
            log.warn((Object)"Unable to load transports from the registry. Some transports may not get initialized.", (Throwable)e);
        }
        this.moduleDeployer = new ModuleDeployer(this.axisConfig);
        return this.axisConfig;
    }

    private void loadTransports() throws Exception {
        ArrayList<TransportInDescription> transportIns = new ArrayList<TransportInDescription>();
        ArrayList<TransportOutDescription> transportOuts = new ArrayList<TransportOutDescription>();
        TransportPersistenceManager transportPM = new TransportPersistenceManager(this.axisConfig);
        String[] transports = transportPM.getEnabledTransports(false);
        if (transports != null) {
            for (String transportToInit : transports) {
                TransportOutDescription transportOutDesc;
                if (this.axisConfig.getTransportOut(transportToInit.trim()) != null || (transportOutDesc = transportPM.getTransportSender(transportToInit, true)) == null) continue;
                transportOuts.add(transportOutDesc);
            }
        }
        if ((transports = transportPM.getEnabledTransports(true)) != null) {
            for (String transportToInit : transports) {
                TransportInDescription transportInDesc;
                if (this.axisConfig.getTransportIn(transportToInit.trim()) != null || (transportInDesc = transportPM.getTransportListener(transportToInit, true)) == null) continue;
                transportIns.add(transportInDesc);
            }
        }
        for (TransportOutDescription trpOut : transportOuts) {
            this.axisConfig.addTransportOut(trpOut);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(trpOut.getName() + " transport sender added to the configuration"));
        }
        for (TransportInDescription trpIn : transportIns) {
            this.axisConfig.addTransportIn(trpIn);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(trpIn.getName() + " transport receiver added to the configuration"));
        }
        transportPM.updateEnabledTransports(this.axisConfig.getTransportsIn().values(), this.axisConfig.getTransportsOut().values());
    }

    public synchronized void runDeployment() {
        this.schedulerTask.runAxisDeployment();
    }

    public void setRepoUpdateFailed() {
        this.schedulerTask.setRepoUpdateFailed();
    }

    protected void startSearch(RepositoryListener listener) {
        this.schedulerTask = new CarbonDeploymentSchedulerTask(listener, this.axisConfig, -1234, "carbon.super");
        this.scheduler = Executors.newScheduledThreadPool(1);
        String deploymentInterval = CarbonCoreDataHolder.getInstance().getServerConfigurationService().getFirstProperty("Axis2Config.DeploymentUpdateInterval");
        int deploymentIntervalInt = 15;
        if (deploymentInterval != null) {
            deploymentIntervalInt = Integer.parseInt(deploymentInterval);
        }
        this.scheduler.scheduleWithFixedDelay((Runnable)((Object)this.schedulerTask), 0L, deploymentIntervalInt, TimeUnit.SECONDS);
    }

    public void cleanup() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        super.cleanup();
    }

    public void loadServices() {
        CarbonAxisConfigurator.setWebLocationString((String)this.webLocation);
        if (this.repoLocation != null && this.repoLocation.trim().length() != 0) {
            if (this.isUrlRepo) {
                try {
                    this.loadServicesFromUrl(new URL(this.repoLocation));
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Services repository URL " + this.repoLocation + " is invalid"));
                }
            } else {
                super.loadServices();
            }
        }
    }

    public void addAxis2ConfigServiceListener() throws Exception {
        this.bundleContext.addServiceListener((ServiceListener)this.configServiceListener, "(org.apache.axis2.osgi.config.service=*)");
    }

    public void setAxis2ConfigItemHolder(Axis2ConfigItemHolder configItemHolder) {
        this.configItemHolder = configItemHolder;
    }

    protected void prepareRepository(String repositoryName) {
        this.repositoryDir = new File(repositoryName);
        if (this.servicesPath != null && !GhostDeployerUtils.isGhostOn()) {
            this.servicesDir = new File(this.servicesPath);
            if (!this.servicesDir.exists()) {
                this.servicesDir = new File(this.repositoryDir, this.servicesPath);
            }
        } else {
            this.servicesDir = new File(this.repositoryDir, "services");
        }
        if (this.modulesPath != null) {
            this.modulesDir = new File(this.modulesPath);
            if (!this.modulesDir.exists()) {
                this.modulesDir = new File(this.repositoryDir, this.modulesPath);
            }
        } else {
            this.modulesDir = new File(this.repositoryDir, "modules");
        }
        if (!this.modulesDir.exists()) {
            log.info((Object)Messages.getMessage((String)"nomoduledirfound", (String)this.getRepositoryPath(this.repositoryDir)));
        }
    }

    public File getRepositoryDir() {
        return this.repositoryDir;
    }

    private InputStream getAxis2XmlInputStream() throws AxisFault {
        InputStream axis2xmlStream;
        block6: {
            axis2xmlStream = null;
            try {
                if (this.axis2xml != null && this.axis2xml.trim().length() != 0) {
                    if (this.isUrlAxis2Xml) {
                        try {
                            axis2xmlStream = new URL(this.axis2xml).openStream();
                            break block6;
                        }
                        catch (IOException e) {
                            throw new AxisFault("Cannot load axis2.xml from URL", (Throwable)e);
                        }
                    }
                    axis2xmlStream = new FileInputStream(this.axis2xml);
                    break block6;
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                axis2xmlStream = cl.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
            }
            catch (IOException e) {
                log.error((Object)"Cannot find axis2.xml file", (Throwable)e);
            }
        }
        return axis2xmlStream;
    }
}

