/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.init;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.core.init.CarbonServerManager;

public class PreAxis2ConfigItemListener
implements BundleListener {
    private static Log log = LogFactory.getLog(PreAxis2ConfigItemListener.class);
    private Map<String, Bundle> moduleBundleMap = new HashMap<String, Bundle>();
    private Map<String, Bundle> deployerBundleMap = new HashMap<String, Bundle>();
    private BundleContext bundleContext;
    private CarbonServerManager carbonServerManager;
    private boolean listenerRegistered;

    public PreAxis2ConfigItemListener(BundleContext bundleContext, CarbonServerManager carbonServerManager) {
        this.bundleContext = bundleContext;
        this.carbonServerManager = carbonServerManager;
    }

    boolean registerBundleListener() {
        if (this.moduleBundleMap.isEmpty() && this.deployerBundleMap.isEmpty()) {
            this.listenerRegistered = false;
        } else {
            this.bundleContext.addBundleListener((BundleListener)this);
            this.listenerRegistered = true;
        }
        return this.listenerRegistered;
    }

    void unregisterBundleListener() {
        if (this.listenerRegistered) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
    }

    synchronized void start() {
        Bundle bundle;
        for (String moduleName : this.moduleBundleMap.keySet()) {
            bundle = this.moduleBundleMap.get(moduleName);
            if (bundle.getState() == 32) continue;
            this.carbonServerManager.addPendingItem(moduleName, "Module");
        }
        for (String moduleName : this.deployerBundleMap.keySet()) {
            bundle = this.deployerBundleMap.get(moduleName);
            if (bundle.getState() == 32) continue;
            this.carbonServerManager.addPendingItem(moduleName, "Deployer");
        }
    }

    void addModuleBundle(String moduleName, Bundle bundle) {
        this.moduleBundleMap.put(moduleName, bundle);
    }

    void addDeployerBundle(String deployerName, Bundle bundle) {
        this.deployerBundleMap.put(deployerName, bundle);
    }

    public synchronized void bundleChanged(BundleEvent event) {
        if (event.getType() != 2) {
            return;
        }
        Dictionary headers = event.getBundle().getHeaders();
        String value = (String)headers.get("Axis2Deployer");
        if (value != null) {
            this.carbonServerManager.removePendingItem(value);
        }
        if ((value = (String)headers.get("Axis2Module")) != null) {
            this.carbonServerManager.removePendingItem(value);
        }
    }

    public Bundle[] getModuleBundles() {
        return this.moduleBundleMap.values().toArray(new Bundle[this.moduleBundleMap.size()]);
    }

    public Bundle[] getDeployerBundles() {
        return this.deployerBundleMap.values().toArray(new Bundle[this.deployerBundleMap.size()]);
    }
}

