/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AnonymousSessionUtil {
    private static Log log = LogFactory.getLog(AnonymousSessionUtil.class);

    public static UserRegistry getSystemRegistryByUserName(RegistryService registryService, RealmService realmService, String userName) throws CarbonException {
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            return AnonymousSessionUtil.getSystemRegistryByDomainName(registryService, realmService, tenantDomain);
        }
        catch (Exception e) {
            throw new CarbonException(e.getMessage(), (Throwable)e);
        }
    }

    public static UserRegistry getUserRegistryByUserName(RegistryService registryService, RealmService realmService, String userName) throws CarbonException {
        try {
            return registryService.getUserRegistry(userName);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException(e.getMessage(), (Throwable)e);
        }
    }

    public static UserRegistry getSystemRegistryByDomainName(RegistryService registryService, RealmService realmService, String domainName) throws CarbonException {
        try {
            int tenantId = realmService.getTenantManager().getTenantId(domainName);
            if (tenantId == -1) {
                throw new CarbonException("Invalid domain name");
            }
            if (!realmService.getTenantManager().isTenantActive(tenantId)) {
                throw new CarbonException("Inactive tenant");
            }
            return registryService.getConfigSystemRegistry(tenantId);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException(e.getMessage(), (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException(e.getMessage(), (Throwable)e);
        }
    }

    public static UserRegistry getUserRegistry(RegistryService registryService, String userName) throws CarbonException {
        try {
            return registryService.getUserRegistry(userName);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException(e.getMessage(), (Throwable)e);
        }
    }

    public static UserRealm getRealmByUserName(RegistryService registryService, RealmService realmService, String userName) throws CarbonException {
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            return AnonymousSessionUtil.getRealmByTenantDomain(registryService, realmService, tenantDomain);
        }
        catch (Exception e) {
            throw new CarbonException(e.getMessage(), (Throwable)e);
        }
    }

    public static UserRealm getRealmByTenantDomain(RegistryService registryService, RealmService realmService, String tenantDomain) throws CarbonException {
        try {
            if ("carbon.super".equals(tenantDomain)) {
                return realmService.getBootstrapRealm();
            }
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            if (tenantId == -1) {
                log.warn((Object)("Failed to retrieve Realm for the Invalid Domain : " + tenantDomain));
                return null;
            }
            if (!realmService.getTenantManager().isTenantActive(tenantId)) {
                log.warn((Object)("Failed to retrieve Realm for the inactive tenant : " + tenantDomain));
                return null;
            }
            return registryService.getUserRealm(tenantId);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException(e.getMessage(), (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException(e.getMessage(), (Throwable)e);
        }
    }
}

