/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class UMDatabaseManager {
    private DataSource dataSource = null;
    private final String CREATE_TABLE = "CREATE TABLE USER_MGT_PROPERTIES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY, PROPERTY_NAME VARCHAR(255) NOT NULL, PROPERTY_VALUE VARCHAR(255), PRIMARY KEY (ID))";
    private final String SET_PROPERTY = "INSERT INTO USER_MGT_PROPERTIES(PROPERTY_NAME, PROPERTY_VALUE) VALUES (?,?)";
    private final String GET_PROPERTY = "SELECT PROPERTY_VALUE FROM USER_MGT_PROPERTIES WHERE PROPERTY_NAME=?";
    private final String GET_PROPERTIES = "SELECT PROPERTY_NAME, PROPERTY_VALUE FROM USER_MGT_PROPERTIES";
    private final String DELETE_PROPERTIES = "DELETE * FROM USER_MGT_PROPERTIES";

    public UMDatabaseManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) throws SQLException {
        String value = null;
        PreparedStatement stmt = null;
        Connection dbConnection = null;
        ResultSet rs = null;
        try {
            dbConnection = this.dataSource.getConnection();
            stmt = dbConnection.prepareStatement("SELECT PROPERTY_VALUE FROM USER_MGT_PROPERTIES WHERE PROPERTY_NAME=?");
            stmt.setString(1, name);
            stmt.executeQuery();
            rs = stmt.executeQuery();
            if (rs.next()) {
                value = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            DatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement[])new PreparedStatement[]{stmt});
            throw throwable;
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement[])new PreparedStatement[]{stmt});
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExternalStoreProperties() throws SQLException {
        Connection dbConnection = null;
        HashMap<String, String> map = new HashMap<String, String>();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            dbConnection = this.dataSource.getConnection();
            stmt = dbConnection.prepareStatement("SELECT PROPERTY_NAME, PROPERTY_VALUE FROM USER_MGT_PROPERTIES");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                map.put(name, value);
            }
        }
        catch (Throwable throwable) {
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement[])new PreparedStatement[]{stmt});
            throw throwable;
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement[])new PreparedStatement[]{stmt});
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllProperties() throws SQLException {
        Connection dbConnection = null;
        HashMap map = new HashMap();
        PreparedStatement stmt = null;
        try {
            dbConnection = this.dataSource.getConnection();
            stmt = dbConnection.prepareStatement("DELETE * FROM USER_MGT_PROPERTIES");
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{stmt});
            throw throwable;
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{stmt});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) throws SQLException {
        Connection dbConnection = null;
        PreparedStatement stmt = null;
        try {
            this.dataSource.getConnection();
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            stmt = dbConnection.prepareStatement("INSERT INTO USER_MGT_PROPERTIES(PROPERTY_NAME, PROPERTY_VALUE) VALUES (?,?)");
            stmt.setString(1, name);
            stmt.setString(2, value);
            stmt.executeUpdate();
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{stmt});
            throw throwable;
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{stmt});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createManagementTables() throws SQLException {
        Connection dbConnection = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            dbConnection = this.dataSource.getConnection();
            DatabaseMetaData dbmd = dbConnection.getMetaData();
            rs = dbmd.getTables(null, null, "USER_MGT_PROPERTIES", null);
            stmt = dbConnection.createStatement(1004, 1008);
            if (!rs.next()) {
                stmt.executeUpdate("CREATE TABLE USER_MGT_PROPERTIES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY, PROPERTY_NAME VARCHAR(255) NOT NULL, PROPERTY_VALUE VARCHAR(255), PRIMARY KEY (ID))");
                dbConnection.commit();
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[0]);
        }
    }
}

