/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.listener.AuthorizationManagerListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.mgt.internal.UserMgtInitializer;
import org.wso2.carbon.user.mgt.listeners.PermissionAuthorizationListener;
import org.wso2.carbon.user.mgt.permission.ManagementPermissionsAdder;

public class UserMgtDSComponent {
    private static Log log = LogFactory.getLog(UserMgtDSComponent.class);
    private static RegistryService registryService = null;
    private static RealmService realmService = null;

    protected void activate(ComponentContext ctxt) {
        log.debug((Object)"User Mgt bundle is activated ");
        UserMgtInitializer userMgtInitializer = new UserMgtInitializer();
        try {
            Bundle[] bundles;
            userMgtInitializer.start(ctxt.getBundleContext(), registryService);
            ManagementPermissionsAdder uiPermissionAdder = new ManagementPermissionsAdder();
            ctxt.getBundleContext().addBundleListener((BundleListener)uiPermissionAdder);
            for (Bundle bundle : bundles = ctxt.getBundleContext().getBundles()) {
                if (bundle.getState() != 32) continue;
                uiPermissionAdder.addUIPermissionFromBundle(bundle);
            }
            ctxt.getBundleContext().registerService(AuthorizationManagerListener.class.getName(), (Object)new PermissionAuthorizationListener(), null);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"User Mgt bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service");
        }
        UserMgtDSComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        UserMgtDSComponent.registryService = null;
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service");
        }
        UserMgtDSComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Realm Service");
        }
        UserMgtDSComponent.realmService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }
}

