/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.multiplecredentials;

import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.multiplecredentials.Credential;
import org.wso2.carbon.user.core.multiplecredentials.MultipleCredentialUserStoreManager;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.MultipleCredentialsUserAdminException;
import org.wso2.carbon.user.mgt.multiplecredentials.MultipleCredentialsNotSupportedException;

public class MultipleCredentialsUserProxy {
    private UserRealm realm;
    private static final String DOMAIN_PARAMETER = "multipleCredentialDomain";
    private static final String MULTIPLE_CREDENTIAL_DOMAIN_NAME = "multipleCredential.com";
    private static Log log = LogFactory.getLog(MultipleCredentialsUserProxy.class);
    private static final Object lock = new Object();
    private static MultipleCredentialUserStoreManager userStoreManager;

    public MultipleCredentialsUserProxy(UserRealm realm) {
        this.realm = realm;
    }

    private String getLoggedInUser() {
        HttpServletRequest request;
        MessageContext context = MessageContext.getCurrentMessageContext();
        if (context != null && (request = (HttpServletRequest)context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) != null) {
            HttpSession httpSession = request.getSession(false);
            return (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
        }
        return null;
    }

    public void addUser(Credential credential, String[] roles, ClaimValue[] claims, String profileName) throws MultipleCredentialsUserAdminException {
        try {
            roles = this.checkRolesPermissions(roles);
            MultipleCredentialUserStoreManager mgr = this.getUserStoreManager();
            HashMap<String, String> claimMap = new HashMap<String, String>();
            if (claims != null) {
                for (ClaimValue claimValue : claims) {
                    claimMap.put(claimValue.getClaimURI(), claimValue.getValue());
                }
            }
            mgr.addUser(credential, roles, claimMap, profileName);
        }
        catch (UserStoreException e) {
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
    }

    private String[] checkRolesPermissions(String[] roles) throws UserStoreException, MultipleCredentialsUserAdminException {
        RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
        if (realmConfig.getUserStoreProperty("ExternalIdP") != null) {
            throw new MultipleCredentialsUserAdminException("Please contact your external Identity Provider to add users");
        }
        if (roles != null) {
            String loggedInUserName = this.getLoggedInUser();
            Arrays.sort(roles);
            boolean isRoleHasAdminPermission = false;
            for (String role : roles) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(role, "/permission", "ui.execute");
                if (!isRoleHasAdminPermission) {
                    isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(role, "/permission/admin", "ui.execute");
                }
                if (isRoleHasAdminPermission) break;
            }
            if ((Arrays.binarySearch(roles, realmConfig.getAdminRoleName()) > -1 || isRoleHasAdminPermission) && !realmConfig.getAdminUserName().equals(loggedInUserName)) {
                log.warn((Object)("An attempt to assign user to Admin permission role by user : " + loggedInUserName));
                throw new UserStoreException("Can not assign user to Admin permission role");
            }
            boolean isContained = false;
            String[] temp = new String[roles.length + 1];
            for (int i = 0; i < roles.length; ++i) {
                temp[i] = roles[i];
                if (!roles[i].equals(realmConfig.getEveryOneRoleName())) continue;
                isContained = true;
                break;
            }
            if (!isContained) {
                temp[roles.length] = realmConfig.getEveryOneRoleName();
                roles = temp;
            }
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultipleCredentialUserStoreManager getUserStoreManager() throws UserStoreException {
        if (userStoreManager == null) {
            Object object = lock;
            synchronized (object) {
                if (userStoreManager == null) {
                    UserStoreManager storeManager;
                    UserStoreManager second;
                    AxisConfiguration axisConfiguration = CarbonConfigurationContextFactory.getConfigurationContext().getAxisConfiguration();
                    String multipleCredentialDomain = (String)axisConfiguration.getParameterValue(DOMAIN_PARAMETER);
                    if (multipleCredentialDomain == null) {
                        multipleCredentialDomain = MULTIPLE_CREDENTIAL_DOMAIN_NAME;
                    }
                    if ((second = (storeManager = this.realm.getUserStoreManager()).getSecondaryUserStoreManager(multipleCredentialDomain)) != null) {
                        storeManager = second;
                    }
                    if (!(storeManager instanceof MultipleCredentialUserStoreManager)) {
                        String msg = "User store does not support multiple credentials.";
                        MultipleCredentialsNotSupportedException e = new MultipleCredentialsNotSupportedException(msg);
                        log.fatal((Object)msg, (Throwable)((Object)e));
                        throw e;
                    }
                    userStoreManager = (MultipleCredentialUserStoreManager)storeManager;
                }
            }
        }
        return userStoreManager;
    }

    public void addUser(Credential[] credential, String[] roles, ClaimValue[] claims, String profileName) throws MultipleCredentialsUserAdminException {
        try {
            roles = this.checkRolesPermissions(roles);
            MultipleCredentialUserStoreManager mgr = this.getUserStoreManager();
            HashMap<String, String> claimMap = new HashMap<String, String>();
            if (claims != null) {
                for (ClaimValue claimValue : claims) {
                    claimMap.put(claimValue.getClaimURI(), claimValue.getValue());
                }
            }
            mgr.addUser(credential, roles, claimMap, profileName);
        }
        catch (UserStoreException e) {
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
    }

    public void deleteUser(String userName, String credentialType, Registry registry) throws MultipleCredentialsUserAdminException {
        try {
            String loggedInUserName = this.getLoggedInUser();
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            if (userName != null && userName.equals(realmConfig.getAdminUserName()) && !userName.equals(loggedInUserName)) {
                log.warn((Object)("An attempt to delete Admin user by user : " + loggedInUserName));
                throw new UserStoreException("Can not delete Admin user");
            }
            MultipleCredentialUserStoreManager mgr = this.getUserStoreManager();
            if (userName != null) {
                Object[] roles = mgr.getRoleListOfUser(userName, credentialType);
                Arrays.sort(roles);
                if (!(Arrays.binarySearch(roles, realmConfig.getAdminRoleName()) <= -1 || loggedInUserName == null || userName.equals(loggedInUserName) || realmConfig.getAdminUserName().equals(loggedInUserName) || userName.equals(realmConfig.getAdminUserName()))) {
                    log.warn((Object)("An attempt to delete user in Admin role by user : " + loggedInUserName));
                    throw new UserStoreException("Can not delete user in Admin role");
                }
            }
            mgr.deleteUser(userName, credentialType);
            String path = "/users/" + userName;
            if (registry.resourceExists(path)) {
                registry.delete(path);
            }
        }
        catch (RegistryException e) {
            String msg = "Error deleting user from registry, " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new MultipleCredentialsUserAdminException(msg, e);
        }
        catch (UserStoreException e) {
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
    }

    public void addCredential(String anIdentifier, String credentialType, Credential credential) throws MultipleCredentialsUserAdminException {
        try {
            MultipleCredentialUserStoreManager mgr = this.getUserStoreManager();
            mgr.addCredential(anIdentifier, credentialType, credential);
        }
        catch (UserStoreException e) {
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
    }

    public void updateCredential(String identifier, String credentialType, Credential credential) throws MultipleCredentialsUserAdminException {
        try {
            MultipleCredentialUserStoreManager mgr = this.getUserStoreManager();
            mgr.updateCredential(identifier, credentialType, credential);
        }
        catch (UserStoreException e) {
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
    }

    public void deleteCredential(String identifier, String credentialType) throws MultipleCredentialsUserAdminException {
        try {
            MultipleCredentialUserStoreManager mgr = this.getUserStoreManager();
            mgr.deleteCredential(identifier, credentialType);
        }
        catch (UserStoreException e) {
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
    }

    public Credential[] getCredentials(String anIdentifier, String credentialType) throws MultipleCredentialsUserAdminException {
        try {
            MultipleCredentialUserStoreManager mgr = this.getUserStoreManager();
            return mgr.getCredentials(anIdentifier, credentialType);
        }
        catch (UserStoreException e) {
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
    }

    public boolean authenticate(Credential credential) throws MultipleCredentialsUserAdminException {
        try {
            MultipleCredentialUserStoreManager mgr = this.getUserStoreManager();
            return mgr.authenticate(credential);
        }
        catch (UserStoreException e) {
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new MultipleCredentialsUserAdminException(e.getMessage(), e);
        }
    }
}

