/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.abdera.filter.ParseFilter;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.parser.stax.FOMElement;
import org.apache.abdera.parser.stax.FOMFactory;
import org.apache.abdera.parser.stax.FOMTextValue;
import org.apache.abdera.parser.stax.FOMUnsupportedContentTypeException;
import org.apache.abdera.parser.stax.FOMUnsupportedTextTypeException;
import org.apache.abdera.util.Constants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.util.OMSerializerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMBuilder
extends StAXOMBuilder
implements Constants {
    private final FOMFactory fomfactory;
    private final ParserOptions parserOptions;
    private boolean indoc = false;
    private int depth = 0;
    private int depthInSkipElement = 0;
    private boolean ignoreWhitespace = false;
    private boolean ignoreComments = false;
    private boolean ignorePI = false;

    public FOMBuilder(FOMFactory factory, XMLStreamReader parser, ParserOptions parserOptions) {
        super((OMFactory)factory, parser);
        ParseFilter parseFilter;
        this.document = (OMDocument)factory.newDocument();
        this.parserOptions = parserOptions;
        this.fomfactory = factory;
        String enc = parser.getCharacterEncodingScheme();
        this.document.setCharsetEncoding(enc != null ? enc : "utf-8");
        this.document.setXMLVersion(parser.getVersion() != null ? parser.getVersion() : "1.0");
        if (parserOptions != null && (parseFilter = parserOptions.getParseFilter()) != null) {
            this.ignoreWhitespace = parseFilter.getIgnoreWhitespace();
            this.ignoreComments = parseFilter.getIgnoreComments();
            this.ignorePI = parseFilter.getIgnoreProcessingInstructions();
        }
    }

    public ParserOptions getParserOptions() {
        return this.parserOptions;
    }

    protected OMNode createOMElement() throws OMException {
        OMElement node;
        ++this.depth;
        String elementName = this.parser.getLocalName();
        if (this.lastNode == null) {
            node = this.constructNode(null, elementName);
        } else if (this.lastNode.isComplete()) {
            node = this.constructNode(this.lastNode.getParent(), elementName);
            if (node != null) {
                ((OMNodeEx)this.lastNode).setNextOMSibling((OMNode)node);
                ((OMNodeEx)node).setPreviousOMSibling(this.lastNode);
            }
        } else {
            OMElement e = (OMElement)this.lastNode;
            node = this.constructNode((OMContainer)((OMElement)this.lastNode), elementName);
            e.setFirstChild((OMNode)node);
        }
        return node;
    }

    protected Text.Type getTextType() {
        Text.Type ttype = Text.Type.TEXT;
        String type = this.parser.getAttributeValue(null, "type");
        if (type != null && (ttype = Text.Type.typeFromString(type)) == null) {
            throw new FOMUnsupportedTextTypeException(type);
        }
        return ttype;
    }

    protected Content.Type getContentType() {
        Content.Type ctype = Content.Type.TEXT;
        String type = this.parser.getAttributeValue(null, "type");
        String src = this.parser.getAttributeValue(null, "src");
        if (type != null) {
            ctype = Content.Type.typeFromString(type);
            if (ctype == null) {
                throw new FOMUnsupportedContentTypeException(type);
            }
        } else if (type == null && src != null) {
            ctype = Content.Type.MEDIA;
        }
        return ctype;
    }

    private boolean isAcceptableToParse(QName qname, boolean attribute) {
        if (this.parserOptions == null) {
            return true;
        }
        ParseFilter filter = this.parserOptions.getParseFilter();
        return filter != null ? (!attribute ? filter.acceptable(qname) : filter.acceptable(this.parser.getName(), qname)) : true;
    }

    private OMNode applyTextFilter(int type) {
        ParseFilter parseFilter;
        if (this.parserOptions != null && (parseFilter = this.parserOptions.getParseFilter()) != null && this.parser.isWhiteSpace() && parseFilter.getIgnoreWhitespace()) {
            return this.createOMText("", type);
        }
        return this.createOMText(type);
    }

    private int getNextElementToParse() throws XMLStreamException {
        int token = this.parser.next();
        if (this.depthInSkipElement == 0 && token != 1) {
            return token;
        }
        if (token == 1 && this.isAcceptableToParse(this.parser.getName(), false) && this.depthInSkipElement == 0) {
            return token;
        }
        if (token == 1) {
            ++this.depthInSkipElement;
        } else if (token == 2) {
            --this.depthInSkipElement;
        }
        return this.getNextElementToParse();
    }

    public int next() throws OMException {
        try {
            if (this.done) {
                throw new OMException();
            }
            int token = this.getNextElementToParse();
            if (!this.cache) {
                return token;
            }
            switch (token) {
                case 1: {
                    this.lastNode = this.createOMElement();
                    break;
                }
                case 7: {
                    this.document.setXMLVersion(this.parser.getVersion() != null ? this.parser.getVersion() : "1.0");
                    this.document.setCharsetEncoding(this.parser.getEncoding() != null ? this.parser.getEncoding() : "utf-8");
                    this.document.setStandalone(this.parser.isStandalone() ? "yes" : "no");
                    break;
                }
                case 4: {
                    this.lastNode = this.applyTextFilter(4);
                    break;
                }
                case 12: {
                    this.lastNode = this.applyTextFilter(12);
                    break;
                }
                case 2: {
                    this.endElement();
                    break;
                }
                case 8: {
                    this.done = true;
                    ((OMContainerEx)this.document).setComplete(true);
                    break;
                }
                case 6: {
                    if (this.ignoreWhitespace) break;
                    this.lastNode = this.createOMText(6);
                    break;
                }
                case 5: {
                    if (this.ignoreComments) break;
                    this.createComment();
                    break;
                }
                case 11: {
                    break;
                }
                case 3: {
                    if (this.ignorePI) break;
                    this.createPI();
                    break;
                }
                case 9: {
                    String val = this.parserOptions.resolveEntity(super.getName());
                    if (val == null) {
                        throw new ParseException("Unresolved undeclared entity: " + super.getName());
                    }
                    this.lastNode = this.createOMText(val, 4);
                    break;
                }
                default: {
                    throw new ParseException();
                }
            }
            return token;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (OMException e) {
            throw new ParseException(e);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private QName getAlias(QName qname) {
        Map<QName, QName> map = this.parserOptions.getQNameAliasMap();
        if (map == null) {
            return qname;
        }
        QName alias = map.get(qname);
        return alias != null ? alias : qname;
    }

    protected OMElement constructNode(OMContainer parent, String name) {
        OMElement element = null;
        if (!this.indoc) {
            parent = this.document;
            this.indoc = true;
        }
        QName qname = this.parser.getName();
        if (this.parserOptions.isQNameAliasMappingEnabled()) {
            qname = this.getAlias(qname);
        }
        if ((element = this.fomfactory.createElement(qname, parent, this)) == null) {
            element = new FOMElement(qname, parent, (OMFactory)this.fomfactory, (OMXMLParserWrapper)this);
        }
        if (element != null) {
            this.processNamespaceData(element);
            this.processAttributes(element);
        }
        return element;
    }

    protected void processAttributes(OMElement node) {
        int attribCount = this.parser.getAttributeCount();
        for (int i = 0; i < attribCount; ++i) {
            QName attr = this.parser.getAttributeName(i);
            if (!this.isAcceptableToParse(attr, true)) continue;
            String uri = this.parser.getAttributeNamespace(i);
            String prefix = this.parser.getAttributePrefix(i);
            OMNamespace namespace = null;
            if (uri != null && uri.length() > 0 && (namespace = node.findNamespace(uri, prefix)) == null) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = OMSerializerUtil.getNextNSPrefix();
                }
                namespace = node.declareNamespace(uri, prefix);
            }
            String value = this.parser.getAttributeValue(i);
            node.addAttribute(this.parser.getAttributeLocalName(i), value, namespace);
        }
    }

    protected void endElement() {
        if (this.lastNode != null && this.lastNode.isComplete()) {
            OMElement parent = (OMElement)this.lastNode.getParent();
            ((OMNodeEx)parent).setComplete(true);
            this.lastNode = parent;
        } else {
            OMNode e = this.lastNode;
            if (e != null) {
                ((OMNodeEx)e).setComplete(true);
            }
        }
        --this.depth;
    }

    public <T extends Element> Document<T> getFomDocument() {
        while (!this.indoc && !this.done) {
            this.next();
        }
        return (Document)this.document;
    }

    public OMDocument getDocument() {
        return (OMDocument)this.getFomDocument();
    }

    public FOMFactory getFactory() {
        return this.fomfactory;
    }

    protected OMNode createOMText(String value, int textType) throws OMException {
        OMNode node = null;
        if (this.lastNode == null) {
            return null;
        }
        if (!this.lastNode.isComplete()) {
            node = this.createOMText(value, (OMElement)this.lastNode, textType);
        } else {
            OMContainer parent = this.lastNode.getParent();
            if (!(parent instanceof OMDocument)) {
                node = this.createOMText(value, (OMElement)parent, textType);
            }
        }
        return node;
    }

    private OMNode createOMText(String value, OMElement omElement, int textType) {
        try {
            if (Boolean.TRUE == this.parser.getProperty("Axiom.IsBinary")) {
                Object dataHandler = this.parser.getProperty("Axiom.DataHandler");
                FOMTextValue text = new FOMTextValue(dataHandler, true, (OMFactory)this);
                omElement.addChild((OMNode)text);
                return text;
            }
            return new FOMTextValue((OMContainer)omElement, value, textType, (OMFactory)this.fomfactory);
        }
        catch (IllegalArgumentException e) {
            return new FOMTextValue((OMContainer)omElement, value, textType, (OMFactory)this.fomfactory);
        }
    }
}

