/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.context;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import org.apache.abdera.protocol.server.context.SimpleResponseContext;
import org.apache.abdera.util.EntityTag;

public class MediaResponseContext
extends SimpleResponseContext {
    private InputStream in;

    public MediaResponseContext(InputStream in, EntityTag etag, int status) {
        this.in = in;
        this.status = status;
        this.setEntityTag(etag);
    }

    public MediaResponseContext(InputStream in, int status) {
        this.in = in;
        this.status = status;
    }

    public MediaResponseContext(InputStream in, Date lastmodified, int status) {
        this.in = in;
        this.status = status;
        this.setLastModified(lastmodified);
    }

    public MediaResponseContext(byte[] bytes, int status) {
        this(new ByteArrayInputStream(bytes), status);
    }

    public MediaResponseContext(byte[] bytes, Date lastmodified, int status) {
        this((InputStream)new ByteArrayInputStream(bytes), lastmodified, status);
    }

    public MediaResponseContext(byte[] bytes, EntityTag etag, int status) {
        this((InputStream)new ByteArrayInputStream(bytes), etag, status);
    }

    public MediaResponseContext(ReadableByteChannel channel, int status) {
        this(Channels.newInputStream(channel), status);
    }

    public MediaResponseContext(ReadableByteChannel channel, Date lastmodified, int status) {
        this(Channels.newInputStream(channel), lastmodified, status);
    }

    public MediaResponseContext(ReadableByteChannel channel, EntityTag etag, int status) {
        this(Channels.newInputStream(channel), etag, status);
    }

    public boolean hasEntity() {
        return this.in != null;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.hasEntity() && this.in != null) {
            byte[] buf = new byte[500];
            int r = -1;
            while ((r = this.in.read(buf)) != -1) {
                out.write(buf, 0, r);
                buf = new byte[100];
            }
        }
    }

    protected void writeEntity(Writer out) throws IOException {
        if (this.in != null) {
            InputStreamReader rdr = new InputStreamReader(this.in);
            char[] buf = new char[500];
            int r = -1;
            while ((r = rdr.read(buf)) != -1) {
                out.write(buf, 0, r);
                buf = new char[100];
            }
        }
    }
}

