/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.engine.Deployable;

public class DeployableChain<T> {
    List<Object> chain = new ArrayList<Object>();
    Deployable first;
    Deployable last;
    Map<String, Set<String>> activeConstraints = new LinkedHashMap<String, Set<String>>();
    private Map<String, Deployable> deployed = new LinkedHashMap<String, Deployable>();

    public void deploy(Deployable deployable) throws Exception {
        Deployable previous;
        String name = deployable.getName();
        Set<String> mySuccessors = deployable.getSuccessors();
        Set<String> myPredecessors = deployable.getPredecessors();
        if (deployable.isFirst()) {
            if (this.first != null) {
                throw new Exception("'" + this.first.getName() + "' is already first, can't deploy '" + name + "' as first also.");
            }
            if (myPredecessors != null) {
                throw new Exception("Deploying '" + name + "' - can't both be first and have predecessors!");
            }
            this.first = deployable;
        }
        if (deployable.isLast()) {
            if (this.last != null) {
                throw new Exception("'" + this.last.getName() + "' is already last, can't deploy '" + name + "' as last also.");
            }
            if (mySuccessors != null) {
                throw new Exception("Deploying '" + name + "' - can't both be last and have successors!");
            }
            this.last = deployable;
        }
        if ((previous = this.deployed.get(name)) == null) {
            this.deployed.put(name, deployable);
        } else {
            if (previous.isFirst() != deployable.isFirst()) {
                throw new Exception("Can't deploy '" + name + "', values for first don't match!");
            }
            if (previous.isLast() != deployable.isLast()) {
                throw new Exception("Can't deploy '" + name + "', values for last don't match!");
            }
            Object target = previous.getTarget();
            if (target != null) {
                if (deployable.getTarget() != null && !target.equals(deployable.getTarget())) {
                    throw new Exception("Can't deploy '" + name + "',  targets must either match or be null.");
                }
            } else {
                previous.setTarget(deployable.getTarget());
            }
        }
        if (mySuccessors != null && !mySuccessors.isEmpty()) {
            Set<String> successors = this.activeConstraints.get(name);
            if (successors == null) {
                successors = new LinkedHashSet<String>();
                this.activeConstraints.put(name, successors);
            }
            successors.addAll(mySuccessors);
        }
        if (myPredecessors != null) {
            Iterator<String> i$ = myPredecessors.iterator();
            while (i$.hasNext()) {
                String myPredecessor;
                String predecessor = myPredecessor = i$.next();
                this.addRelationship(predecessor, name);
            }
        }
    }

    private int getMinIndex(String name, Set<String> remaining, Set<String> seen) throws Exception {
        if (seen.contains(name)) {
            return -1;
        }
        Set<String> successors = this.activeConstraints.get(name);
        if (successors == null || successors.isEmpty()) {
            int index = this.last == null ? this.chain.size() : this.chain.size() - 1;
            this.chain.add(index, name);
            remaining.remove(name);
            return index;
        }
        int minIndex = -1;
        for (String successor : successors) {
            String otherName = successor;
            int otherIdx = this.chain.indexOf(otherName);
            if (otherIdx > -1) {
                if (minIndex != -1 && minIndex <= otherIdx) continue;
                minIndex = otherIdx;
                continue;
            }
            if (this.deployed.get(otherName) == null || !remaining.contains(otherName)) continue;
            seen.add(name);
            int min = this.getMinIndex(otherName, remaining, seen);
            if (minIndex == -1 || min < minIndex) {
                minIndex = min;
            }
            if (minIndex != -1) continue;
            throw new Exception("Trying to put '" + name + "' before '" + otherName + "' - incompatible constraints!");
        }
        if (minIndex == -1) {
            minIndex = 0;
        }
        this.chain.add(minIndex, name);
        remaining.remove(name);
        return minIndex;
    }

    public void rebuild() throws Exception {
        this.chain.clear();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        keys.addAll(this.deployed.keySet());
        if (this.first != null) {
            this.chain.add(this.first.getName());
            keys.remove(this.first.getName());
        }
        if (this.last != null) {
            Set<String> afterLast = this.activeConstraints.get(this.last.getName());
            if (afterLast != null) {
                throw new Exception("Can't have anything which goes after '" + this.last.getName() + "', which has been declared last.");
            }
            this.chain.add(this.last.getName());
            keys.remove(this.last.getName());
        }
        while (!keys.isEmpty()) {
            String name = (String)keys.iterator().next();
            this.getMinIndex(name, keys, new LinkedHashSet<String>());
        }
        for (int i = 0; i < this.chain.size(); ++i) {
            String name = (String)this.chain.get(i);
            this.chain.set(i, this.deployed.get(name).getTarget());
        }
    }

    public void addRelationship(String before, String after) {
        Set<String> successors = this.activeConstraints.get(before);
        if (successors == null) {
            successors = new LinkedHashSet<String>();
            this.activeConstraints.put(before, successors);
        }
        successors.add(after);
    }

    public List<T> getChain() {
        return this.chain;
    }
}

