/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.core.controller.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.ClientUtils;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.client.async.CallbackFuture;
import org.apache.axis2.jaxws.client.async.PollingFuture;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.impl.InvocationControllerImpl;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.util.Constants;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisInvocationController
extends InvocationControllerImpl {
    private static Log log = LogFactory.getLog(AxisInvocationController.class);

    @Override
    public MessageContext doInvoke(MessageContext request) {
        AxisFault faultexception;
        MessageContext response;
        org.apache.axis2.context.MessageContext axisResponseMsgCtx;
        OperationClient opClient;
        block8: {
            QName operationName = AxisInvocationController.getOperationNameToUse(request, ServiceClient.ANON_OUT_IN_OP);
            InvocationContext ic = request.getInvocationContext();
            ServiceClient svcClient = ic.getServiceClient();
            opClient = this.createOperationClient(svcClient, operationName);
            this.initOperationClient(opClient, request);
            Boolean useAsyncMep = (Boolean)request.getProperty(Constants.USE_ASYNC_MEP);
            if (useAsyncMep != null && useAsyncMep.booleanValue() || opClient.getOptions().isUseSeparateListener()) {
                this.configureAsyncListener(opClient);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Asynchronous message exchange not enabled.  The invocation will be synchronous.");
            }
            org.apache.axis2.context.MessageContext axisRequestMsgCtx = request.getAxisMessageContext();
            axisResponseMsgCtx = null;
            response = null;
            faultexception = null;
            try {
                this.execute(opClient, true, axisRequestMsgCtx);
            }
            catch (AxisFault af) {
                opClient.getOperationContext().cleanup();
                faultexception = af;
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)(axisRequestMsgCtx.getLogIDString() + " AxisFault received from client: " + af.getMessage()));
            }
        }
        try {
            axisResponseMsgCtx = opClient.getMessageContext("In");
            response = new MessageContext(axisResponseMsgCtx);
            response.setMEPContext(request.getMEPContext());
            if (!(faultexception == null || response.getMessage() != null && response.getMessage().isFault())) {
                MessageFactory factory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
                Message message = factory.create(request.getMessage().getProtocol());
                response.setLocalException(faultexception);
                response.setMessage(message);
            }
            ThreadContextMigratorUtil.performMigrationToThread("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
        return response;
    }

    @Override
    public void doInvokeOneWay(MessageContext request) throws WebServiceException {
        Boolean useAsyncMep = (Boolean)request.getProperty(Constants.USE_ASYNC_MEP);
        if (useAsyncMep != null && useAsyncMep.booleanValue()) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("onewayAsync"));
        }
        QName operationName = AxisInvocationController.getOperationNameToUse(request, ServiceClient.ANON_OUT_ONLY_OP);
        InvocationContext ic = request.getInvocationContext();
        ServiceClient svcClient = ic.getServiceClient();
        OperationClient opClient = this.createOperationClient(svcClient, operationName);
        this.initOperationClient(opClient, request);
        org.apache.axis2.context.MessageContext axisRequestMsgCtx = request.getAxisMessageContext();
        try {
            this.execute(opClient, true, axisRequestMsgCtx);
        }
        catch (AxisFault af) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(axisRequestMsgCtx.getLogIDString() + " AxisFault received from client: " + af.getMessage()));
            }
            throw ExceptionFactory.makeWebServiceException(ClassUtils.getRootCause(af));
        }
    }

    @Override
    public Future<?> doInvokeAsync(MessageContext request, AsyncHandler callback) {
        QName operationName = AxisInvocationController.getOperationNameToUse(request, ServiceClient.ANON_OUT_IN_OP);
        InvocationContext ic = request.getInvocationContext();
        ServiceClient svcClient = ic.getServiceClient();
        OperationClient opClient = this.createOperationClient(svcClient, operationName);
        this.initOperationClient(opClient, request);
        Boolean useAsyncMep = (Boolean)request.getProperty(Constants.USE_ASYNC_MEP);
        if (useAsyncMep != null && useAsyncMep.booleanValue() || opClient.getOptions().isUseSeparateListener()) {
            this.configureAsyncListener(opClient);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Asynchronous message exchange not enabled.  The invocation will be synchronous.");
        }
        CallbackFuture cbf = null;
        if (callback == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICErr4"));
        }
        cbf = new CallbackFuture(ic, callback);
        opClient.setCallback(cbf);
        org.apache.axis2.context.MessageContext axisRequestMsgCtx = request.getAxisMessageContext();
        try {
            this.execute(opClient, false, axisRequestMsgCtx);
        }
        catch (AxisFault af) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(axisRequestMsgCtx.getLogIDString() + " AxisFault received from client: " + af.getMessage()));
            }
            cbf.onError(af);
        }
        return cbf.getFutureTask();
    }

    @Override
    public Response doInvokeAsync(MessageContext request) {
        QName operationName = AxisInvocationController.getOperationNameToUse(request, ServiceClient.ANON_OUT_IN_OP);
        InvocationContext ic = request.getInvocationContext();
        ServiceClient svcClient = ic.getServiceClient();
        OperationClient opClient = this.createOperationClient(svcClient, operationName);
        this.initOperationClient(opClient, request);
        Boolean useAsyncMep = (Boolean)request.getProperty(Constants.USE_ASYNC_MEP);
        if (useAsyncMep != null && useAsyncMep.booleanValue() || opClient.getOptions().isUseSeparateListener()) {
            this.configureAsyncListener(opClient);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Asynchronous message exchange not enabled.  The invocation will be synchronous.");
        }
        AsyncResponse resp = ic.getAsyncResponseListener();
        PollingFuture pf = new PollingFuture(ic);
        opClient.setCallback(pf);
        org.apache.axis2.context.MessageContext axisRequestMsgCtx = request.getAxisMessageContext();
        try {
            this.execute(opClient, false, axisRequestMsgCtx);
        }
        catch (AxisFault af) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(axisRequestMsgCtx.getLogIDString() + " AxisFault received from client: " + af.getMessage()));
            }
            pf.onError(af);
        }
        return resp;
    }

    @Override
    protected void prepareRequest(MessageContext requestMsgCtx) {
        try {
            if (requestMsgCtx == null) {
                // empty if block
            }
            org.apache.axis2.context.MessageContext axisRequestMsgCtx = requestMsgCtx.getAxisMessageContext();
            MessageUtils.putMessageOnMessageContext(requestMsgCtx.getMessage(), axisRequestMsgCtx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Properties: " + axisRequestMsgCtx.getProperties().toString()));
            }
        }
        catch (WebServiceException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("prepareRequestFail"));
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("prepareRequestFail"), e);
        }
    }

    @Override
    protected void prepareResponse(MessageContext responseMsgCtx) {
    }

    private void initOperationClient(OperationClient opClient, MessageContext requestMsgCtx) {
        org.apache.axis2.context.MessageContext axisRequest = requestMsgCtx.getAxisMessageContext();
        this.setupProperties(requestMsgCtx);
        if (opClient != null) {
            Options options = opClient.getOptions();
            EndpointReference toEPR = axisRequest.getTo();
            if (toEPR == null) {
                String targetUrl = (String)requestMsgCtx.getProperty("javax.xml.ws.service.endpoint.address");
                toEPR = new EndpointReference(targetUrl);
            }
            options.setTo(toEPR);
            String soapAction = ClientUtils.findSOAPAction(requestMsgCtx);
            options.setAction(soapAction);
            long timeout = axisRequest.getOptions().getTimeOutInMilliSeconds();
            options.setTimeOutInMilliSeconds(timeout);
            try {
                opClient.addMessageContext(axisRequest);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private OperationClient createOperationClient(ServiceClient sc, QName operation) {
        if (sc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICCreateOpClientErr1"));
        }
        if (operation == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("ICCreateOpClientErr2"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating OperationClient for operation: " + operation));
        }
        try {
            OperationClient client = sc.createClient(operation);
            return client;
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    private void configureAsyncListener(OperationClient client) {
        client.getOptions().setUseSeparateListener(true);
    }

    private void setupProperties(MessageContext mc) {
        Message msg = mc.getMessage();
        if (msg.isMTOMEnabled()) {
            mc.setProperty("enableMTOM", "true");
        }
        if (mc.isMaintainSession()) {
            mc.getAxisMessageContext().getOptions().setManageSession(true);
        }
        if (mc.containsKey("javax.xml.ws.security.auth.username") || mc.containsKey("javax.xml.ws.security.auth.password")) {
            String userId = (String)mc.getProperty("javax.xml.ws.security.auth.username");
            if (userId == null || userId == "") {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("checkUserName"));
            }
            String password = null;
            if (mc.containsKey("javax.xml.ws.security.auth.password")) {
                password = (String)mc.getProperty("javax.xml.ws.security.auth.password");
            }
            URL url = null;
            try {
                url = new URL((String)mc.getProperty("javax.xml.ws.service.endpoint.address"));
            }
            catch (MalformedURLException e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
            HttpTransportProperties.Authenticator basicAuthentication = new HttpTransportProperties.Authenticator();
            basicAuthentication.setUsername(userId);
            basicAuthentication.setPassword(password);
            basicAuthentication.setHost(url.getHost());
            basicAuthentication.setPort(url.getPort());
            basicAuthentication.setPreemptiveAuthentication(true);
            mc.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", basicAuthentication);
        }
    }

    private static QName getOperationNameToUse(MessageContext requestMsgCtx, QName defaultOpName) {
        QName operationName = null;
        OperationDescription opDesc = requestMsgCtx.getOperationDescription();
        operationName = opDesc != null && opDesc.getAxisOperation() != null ? opDesc.getName() : defaultOpName;
        return operationName;
    }

    private void execute(OperationClient opClient, boolean block, org.apache.axis2.context.MessageContext msgContext) throws AxisFault {
        try {
            this.preExecute(opClient, block, msgContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Read throwExceptionIfSOAPFault property");
            }
            boolean exceptionToBeThrownOnSOAPFault = ClientUtils.getExceptionToBeThrownOnSOAPFault(msgContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)("throwExceptionIfSOAPFault property set on OperationClient.options " + exceptionToBeThrownOnSOAPFault));
            }
            opClient.getOptions().setExceptionToBeThrownOnSOAPFault(exceptionToBeThrownOnSOAPFault);
            opClient.execute(block);
        }
        catch (Throwable e) {
            throw AxisFault.makeFault(ExceptionFactory.makeWebServiceException(e));
        }
        finally {
            this.postExecute(opClient, block, msgContext);
        }
    }

    private void preExecute(OperationClient opClient, boolean block, org.apache.axis2.context.MessageContext msgContext) throws AxisFault {
        msgContext.getOptions().setUseSeparateListener(opClient.getOptions().isUseSeparateListener());
        ThreadContextMigratorUtil.performMigrationToContext("JAXWS-ThreadContextMigrator-List", msgContext);
        opClient.getOptions().setUseSeparateListener(msgContext.getOptions().isUseSeparateListener());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start OperationClient.execute(" + block + ")"));
            log.debug((Object)("UseSeparateListener: " + opClient.getOptions().isUseSeparateListener()));
        }
    }

    private void postExecute(OperationClient opClient, boolean block, org.apache.axis2.context.MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End OperationClient.execute(" + block + ")"));
        }
        ThreadContextMigratorUtil.performContextCleanup("JAXWS-ThreadContextMigrator-List", msgContext);
    }
}

