/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TokenPersister;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.AbstractIssuerConfig;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSBasedRetiredTokenPersister
implements TokenPersister {
    private static Log log = LogFactory.getLog(FSBasedRetiredTokenPersister.class);
    protected String securityTokenStorageFilePath = null;
    protected int maxTokensInMemory;
    private MessageContext msgCtx = null;
    protected TokenStorage tokenStorage = null;
    private Thread persistanceThread = null;
    private final CharSequence tokenExtension = ".token";

    @Override
    public boolean isTokensExist() {
        File tokensDir = new File(this.securityTokenStorageFilePath);
        String[] children = tokensDir.list();
        if (children != null && children.length != 0) {
            for (String child : children) {
                if (!child.contains(this.tokenExtension)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTokenExist(String tokenID) {
        File tokensDir = new File(this.securityTokenStorageFilePath);
        String[] children = tokensDir.list();
        if (children != null && children.length != 0) {
            for (String child : children) {
                String childID;
                if (!child.contains(this.tokenExtension) || !tokenID.equals(childID = child.split("\\.")[0])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void persistTokens(Token[] retiredTokens) throws TrustException {
        for (Token retiredToken : retiredTokens) {
            this.persistToken(retiredToken);
        }
    }

    @Override
    public synchronized void persistToken(Token token) throws TrustException {
        try {
            FileOutputStream outTokenFile = new FileOutputStream(this.securityTokenStorageFilePath + File.separator + token.getId() + ((Object)this.tokenExtension).toString());
            ObjectOutputStream tokenObjOutStream = new ObjectOutputStream(outTokenFile);
            tokenObjOutStream.writeObject(token);
            tokenObjOutStream.close();
        }
        catch (FileNotFoundException e) {
            String errorMessage = "File can not be found/created to persist the token.";
            throw new TrustException(errorMessage, e);
        }
        catch (IOException e) {
            String errorMessage = "I/O error while creating output stream for token";
            throw new TrustException(errorMessage, e);
        }
    }

    @Override
    public Token[] retrieveTokens() {
        return new Token[0];
    }

    @Override
    public Token retrieveToken(String tokenId) throws TrustException {
        Token retrievedToken = null;
        try {
            FileInputStream inTokenFile = new FileInputStream(this.securityTokenStorageFilePath + File.separator + tokenId + ((Object)this.tokenExtension).toString());
            ObjectInputStream tokenObjInStream = new ObjectInputStream(inTokenFile);
            retrievedToken = (Token)tokenObjInStream.readObject();
            tokenObjInStream.close();
        }
        catch (FileNotFoundException e) {
            String errorMessage = "Stored token file can not be found.";
            throw new TrustException(errorMessage, e);
        }
        catch (IOException e) {
            String errorMessage = "I/O error while creating input stream for token";
            throw new TrustException(errorMessage, e);
        }
        catch (ClassNotFoundException e) {
            throw new TrustException(e.getMessage(), e);
        }
        return retrievedToken;
    }

    @Override
    public String[] retrieveTokenIDs() {
        File tokensDir = new File(this.securityTokenStorageFilePath);
        String[] children = tokensDir.list();
        if (children.length == 0) {
            return null;
        }
        String[] persistedTokenIDs = new String[children.length];
        int index = 0;
        for (String child : children) {
            if (!child.contains(this.tokenExtension)) continue;
            persistedTokenIDs[index] = child.split("\\.")[0];
            ++index;
        }
        return persistedTokenIDs;
    }

    @Override
    public void updateToken(Token token) throws TrustException {
        try {
            this.deleteToken(token.getId());
            this.persistToken(token);
        }
        catch (TrustException e) {
            String errorMessage = "Error in updating the token.";
            log.error((Object)errorMessage);
            throw new TrustException(errorMessage, e);
        }
    }

    @Override
    public void deleteToken(String tokenId) throws TrustException {
        File tokenToDelete = new File(this.securityTokenStorageFilePath + File.separator + tokenId + ((Object)this.tokenExtension).toString());
        boolean success = tokenToDelete.delete();
        if (!success) {
            throw new TrustException("Token could not be deleted.");
        }
    }

    @Override
    public void setConfiguration(AbstractIssuerConfig config) throws TrustException {
        this.securityTokenStorageFilePath = (String)((SAMLTokenIssuerConfig)config).getPersisterPropertyMap().get("StoragePath");
        if (this.securityTokenStorageFilePath == null) {
            String errorMessage = "Storage path is not set in configuration.";
            log.error((Object)errorMessage);
            throw new TrustException(errorMessage);
        }
        try {
            this.maxTokensInMemory = Integer.parseInt((String)((SAMLTokenIssuerConfig)config).getPersisterPropertyMap().get("InMemoryThreshold"));
        }
        catch (NumberFormatException e) {
            String errorMessage = "errorReadingStorageThreshold";
            log.error((Object)errorMessage);
            throw new TrustException(errorMessage, e);
        }
    }

    @Override
    public void setMessageContext(MessageContext msgContext) {
        this.msgCtx = msgContext;
    }

    @Override
    public void notifyPersistence() {
        if (this.persistanceThread == null) {
            this.persistanceThread = new Thread(this);
            this.persistanceThread.start();
        }
    }

    public List<String> getRetiredTokens(List<Token> inMemoryTokens) {
        HashMap<String, Date> tokensMap = new HashMap<String, Date>();
        for (Token inMemoryToken : inMemoryTokens) {
            if (!inMemoryToken.isPersistenceEnabled()) continue;
            tokensMap.put(inMemoryToken.getId(), inMemoryToken.getCreated());
        }
        ArrayList keyList = new ArrayList(tokensMap.keySet());
        ArrayList valueList = new ArrayList(tokensMap.values());
        Object[] datesArray = valueList.toArray();
        Arrays.sort(datesArray);
        LinkedHashMap retiredTokenIDMap = new LinkedHashMap();
        for (int i = 0; i < this.maxTokensInMemory / 4; ++i) {
            retiredTokenIDMap.put(keyList.get(valueList.indexOf(datesArray[i])), datesArray[i]);
        }
        ArrayList<String> retiredTokensIDList = new ArrayList<String>();
        for (String tokenID : retiredTokenIDMap.keySet()) {
            retiredTokensIDList.add(tokenID);
        }
        return retiredTokensIDList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.tokenStorage == null) {
            this.tokenStorage = (TokenStorage)this.msgCtx.getConfigurationContext().getProperty("org.apache.rahas.TokenStorage");
        }
        try {
            List<Token> inMemoryTokens = this.tokenStorage.getStorageTokens();
            List<String> persistingTokens = this.getRetiredTokens(inMemoryTokens);
            this.tokenStorage.handlePersistence(persistingTokens);
        }
        catch (TrustException e) {
            String errorMessage = "Error occurred during persistence process.";
            log.error((Object)errorMessage, (Throwable)e);
        }
        finally {
            this.persistanceThread = null;
        }
    }
}

