/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.ClusteringClient;
import org.apache.stratos.cartridge.agent.ELBMembershipListener;
import org.apache.stratos.cartridge.agent.internal.DataHolder;
import org.apache.stratos.cartridge.agent.registrant.RegistrantDatabase;
import org.apache.stratos.cartridge.agent.registrant.RegistrantHealthChecker;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CartridgeAgentServiceComponent {
    private static final Log log = LogFactory.getLog(CartridgeAgentServiceComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) {
        ConfigurationContext configurationContext = DataHolder.getServerConfigContext();
        FileInputStream confFileIPStream = null;
        try {
            long start = System.currentTimeMillis();
            log.info((Object)"Starting WSO2 Cartridge Agent...");
            Properties conf = new Properties();
            confFileIPStream = new FileInputStream(CarbonUtils.getCarbonConfigDirPath() + File.separator + "agent.properties");
            conf.load(confFileIPStream);
            for (String name : conf.stringPropertyNames()) {
                String value = conf.getProperty(name);
                System.setProperty(name, value);
            }
            RegistrantDatabase registrantDatabase = new RegistrantDatabase();
            ClusteringClient clusteringClient = new ClusteringClient(registrantDatabase);
            configurationContext.setProperty("clustering.client", (Object)clusteringClient);
            String healthCheckInterval = conf.getProperty("registrant.heathCheckInterval");
            String threadPoolSize = conf.getProperty("registrant.healthCheckThreadPoolSize");
            int healthCheckIntervalInt = healthCheckInterval == null ? 2000 : Integer.parseInt(healthCheckInterval);
            int threadPoolSizeInt = threadPoolSize == null ? 10 : Integer.parseInt(healthCheckInterval);
            log.info((Object)("Registrant health check interval: " + healthCheckIntervalInt + "s"));
            RegistrantHealthChecker healthChecker = new RegistrantHealthChecker(registrantDatabase, clusteringClient, configurationContext, healthCheckIntervalInt, threadPoolSizeInt);
            clusteringClient.init(conf, configurationContext, new ELBMembershipListener(clusteringClient, configurationContext, registrantDatabase, healthChecker));
            healthChecker.startAll();
            DataHolder.setHealthChecker(healthChecker);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    log.info((Object)"Shutting down WSO2 Cartridge Agent...");
                }
            });
            log.info((Object)("Started Cartridge Agent in " + (System.currentTimeMillis() - start) + "ms"));
        }
        catch (Exception e) {
            log.fatal((Object)"Could not start Cartridge Agent", (Throwable)e);
        }
        finally {
            if (confFileIPStream != null) {
                try {
                    confFileIPStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Cannot close agent.properties file", (Throwable)e);
                }
            }
        }
    }

    protected void deactivate(ComponentContext ctx) {
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.setServerConfigContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
    }
}

