/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.registrant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.InstanceStateNotificationClientThread;
import org.apache.stratos.cartridge.agent.exception.CartridgeAgentException;
import org.apache.stratos.cartridge.agent.registrant.PortMapping;
import org.apache.stratos.cartridge.agent.registrant.Registrant;

public class RegistrantDatabase {
    private static final Log log = LogFactory.getLog(RegistrantDatabase.class);
    private List<Registrant> registrants = new CopyOnWriteArrayList<Registrant>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Registrant registrant) throws CartridgeAgentException {
        if (this.registrants.contains(registrant) && registrant.running()) {
            throw new CartridgeAgentException("Active registrant with key " + registrant.getKey() + " already exists");
        }
        Registrant registrant2 = registrant;
        synchronized (registrant2) {
            if (!this.isAlreadyAdded(registrant)) {
                this.persist(registrant);
                this.registrants.add(registrant);
                log.info((Object)("Added registrant " + registrant));
            } else {
                log.info((Object)("Registrant " + registrant + "has been already added"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(Registrant registrant) throws CartridgeAgentException {
        try {
            ObjectOutput out = null;
            try {
                if (!new File("registrants").exists() && !new File("registrants").mkdirs()) {
                    throw new IOException("Cannot create registrants directory");
                }
                out = new ObjectOutputStream(new FileOutputStream("registrants" + File.separator + registrant.getKey() + ".ser"));
                out.writeObject(registrant);
                out.close();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("Could not serialize registrant " + registrant), (Throwable)e);
        }
    }

    public void stopAll() {
        for (Registrant registrant : this.registrants) {
            new Thread(new InstanceStateNotificationClientThread(registrant, "INACTIVE")).start();
            registrant.stop();
        }
    }

    public boolean containsActive(Registrant registrant) {
        return this.registrants.contains(registrant) && this.registrants.get(this.registrants.indexOf(registrant)).running();
    }

    public List<Registrant> getRegistrants() {
        return Collections.unmodifiableList(this.registrants);
    }

    public boolean isAlreadyAdded(Registrant registrant) {
        boolean alreadyAdded = false;
        for (Registrant registrantFromDb : this.registrants) {
            if (!registrantFromDb.getRemoteHost().equals(registrant.getRemoteHost())) continue;
            PortMapping[] portMappingofRegistrantOfDB = registrantFromDb.getPortMappings();
            PortMapping[] portMappingofRegistrant = registrant.getPortMappings();
            if (portMappingofRegistrant.length != portMappingofRegistrantOfDB.length) continue;
            alreadyAdded = this.checkPortMappings(registrant, registrantFromDb);
        }
        return alreadyAdded;
    }

    private boolean checkPortMappings(Registrant newRegistrant, Registrant existingRegistrant) {
        PortMapping[] portMappingsOfNewRegistrant = newRegistrant.getPortMappings();
        PortMapping[] portMappingsOfExistingRegistrant = existingRegistrant.getPortMappings();
        for (PortMapping portMappingOfNewRegistrant : portMappingsOfNewRegistrant) {
            boolean matchFound = false;
            for (PortMapping portMappingOfExistingRegistrant : portMappingsOfExistingRegistrant) {
                if (!portMappingOfExistingRegistrant.equals(portMappingOfNewRegistrant)) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("***********************************Found matching registrant for " + newRegistrant + " in the Registrant database"));
        }
        return true;
    }
}

