/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.registrant;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.ClusteringClient;
import org.apache.stratos.cartridge.agent.InstanceStateNotificationClientThread;
import org.apache.stratos.cartridge.agent.registrant.Registrant;
import org.apache.stratos.cartridge.agent.registrant.RegistrantDatabase;
import org.apache.stratos.cartridge.agent.registrant.RegistrantUtil;

public class RegistrantHealthChecker {
    private static final Log log = LogFactory.getLog(RegistrantHealthChecker.class);
    private RegistrantDatabase database;
    private ClusteringClient clusteringClient;
    private ConfigurationContext configurationContext;
    private ScheduledExecutorService scheduler;
    private volatile boolean isELBRunning;
    private int healthCheckInterval;

    public RegistrantHealthChecker(RegistrantDatabase database, ClusteringClient clusteringClient, ConfigurationContext configurationContext, int healthCheckInterval, int threadPoolSize) {
        this.database = database;
        this.clusteringClient = clusteringClient;
        this.configurationContext = configurationContext;
        this.healthCheckInterval = healthCheckInterval;
        this.scheduler = Executors.newScheduledThreadPool(threadPoolSize);
    }

    public void startAll() {
        List<Registrant> registrants = this.database.getRegistrants();
        for (Registrant registrant : registrants) {
            this.scheduler.scheduleWithFixedDelay(new HealthCheckerTask(registrant), 45L, this.healthCheckInterval, TimeUnit.SECONDS);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Started a health checker for " + registrant + " ..."));
        }
    }

    public void start(Registrant registrant) {
        this.scheduler.scheduleWithFixedDelay(new HealthCheckerTask(registrant), 45L, this.healthCheckInterval, TimeUnit.SECONDS);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added a health checker for " + registrant + " ..."));
        }
    }

    public void setELBRunning(boolean ELBRunning) {
        this.isELBRunning = ELBRunning;
    }

    private final class HealthCheckerTask
    implements Runnable {
        Registrant registrant;

        public HealthCheckerTask(Registrant registrant) {
            this.registrant = registrant;
        }

        @Override
        public void run() {
            if (!RegistrantHealthChecker.this.isELBRunning) {
                return;
            }
            try {
                boolean healthyRegistrant = RegistrantUtil.isHealthy(this.registrant);
                if (!healthyRegistrant && this.registrant.running()) {
                    this.registrant.stop();
                    new Thread(new InstanceStateNotificationClientThread(this.registrant, "INACTIVE")).start();
                    log.warn((Object)("Stopped registrant " + this.registrant + " since it is unhealthy."));
                } else if (healthyRegistrant && !this.registrant.running()) {
                    this.registrant.stop();
                    new Thread(new InstanceStateNotificationClientThread(this.registrant, "INACTIVE")).start();
                    RegistrantHealthChecker.this.clusteringClient.joinGroup(this.registrant, RegistrantHealthChecker.this.configurationContext);
                    log.info((Object)("Restarted registrant " + this.registrant + " after it became active"));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while running registrant health check", (Throwable)e);
            }
        }
    }
}

