/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.service;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.ClusteringClient;
import org.apache.stratos.cartridge.agent.exception.CartridgeAgentException;
import org.apache.stratos.cartridge.agent.internal.DataHolder;
import org.apache.stratos.cartridge.agent.registrant.Registrant;

public class CartridgeAgentService {
    private static final Log log = LogFactory.getLog(CartridgeAgentService.class);

    public boolean register(Registrant registrant) throws CartridgeAgentException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        ConfigurationContext configurationContext = messageContext.getConfigurationContext();
        ClusteringClient clusteringClient = (ClusteringClient)configurationContext.getProperty("clustering.client");
        if (registrant.getRemoteHost() == null || registrant.getRemoteHost().isEmpty()) {
            String remoteAddr = (String)messageContext.getProperty("REMOTE_ADDR");
            registrant.setRemoteHost(remoteAddr);
        }
        log.info((Object)("Trying to add new registrant " + registrant + "..."));
        clusteringClient.joinGroup(registrant, configurationContext);
        DataHolder.getHealthChecker().start(registrant);
        return true;
    }

    public boolean unregister(String domain, String subDomain, String hostName) throws CartridgeAgentException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        ConfigurationContext configurationContext = messageContext.getConfigurationContext();
        ClusteringClient clusteringClient = (ClusteringClient)configurationContext.getProperty("clustering.client");
        clusteringClient.removeClusterDomain(domain, subDomain, hostName, configurationContext);
        return true;
    }
}

