/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.EhCache;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.Timestamper;

public final class EhCacheProvider
implements CacheProvider {
    public static final String NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME = "net.sf.ehcache.configurationResourceName";
    private static final Log LOG = LogFactory.getLog(EhCacheProvider.class);
    private CacheManager manager;

    public final Cache buildCache(String name, Properties properties) throws org.hibernate.cache.CacheException {
        try {
            Ehcache cache = this.manager.getEhcache(name);
            if (cache == null) {
                LOG.warn((Object)("Could not find a specific ehcache configuration for cache named [" + name + "]; using defaults."));
                this.manager.addCache(name);
                cache = this.manager.getEhcache(name);
                LOG.debug((Object)("started EHCache region: " + name));
            }
            return new EhCache(cache);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Exception)e);
        }
    }

    public final long nextTimestamp() {
        return Timestamper.next();
    }

    public final void start(Properties properties) throws org.hibernate.cache.CacheException {
        if (this.manager != null) {
            LOG.warn((Object)"Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Using previously created EhCacheProvider. If this behaviour is required, consider using SingletonEhCacheProvider.");
            return;
        }
        try {
            String configurationResourceName = null;
            if (properties != null) {
                configurationResourceName = (String)properties.get(NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME);
            }
            if (configurationResourceName == null || configurationResourceName.length() == 0) {
                this.manager = new CacheManager();
            } else {
                URL url = this.loadResource(configurationResourceName);
                this.manager = new CacheManager(url);
            }
        }
        catch (CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new org.hibernate.cache.CacheException("Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Consider using SingletonEhCacheProvider. Error from  ehcache was: " + e.getMessage());
            }
            throw e;
        }
    }

    private URL loadResource(String configurationResourceName) {
        ClassLoader standardClassloader = ClassLoaderUtil.getStandardClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(configurationResourceName);
        }
        if (url == null) {
            url = this.getClass().getResource(configurationResourceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating EhCacheProvider from a specified resource: " + configurationResourceName + " Resolved to URL: " + url));
        }
        if (url == null && LOG.isWarnEnabled()) {
            LOG.warn((Object)("A configurationResourceName was set to " + configurationResourceName + " but the resource could not be loaded from the classpath." + "Ehcache will configure itself using defaults."));
        }
        return url;
    }

    public final void stop() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.manager = null;
        }
    }

    public final boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

