/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.Definitions;
import org.apache.tiles.definition.NoSuchDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionsImpl
implements Definitions {
    private static Log log = LogFactory.getLog(DefinitionsImpl.class);
    private Map<String, Definition> baseDefinitions = new HashMap<String, Definition>();
    private Map<Locale, Map<String, Definition>> localeSpecificDefinitions = new HashMap<Locale, Map<String, Definition>>();

    @Override
    public Definition getDefinition(String name) {
        return this.baseDefinitions.get(name);
    }

    @Override
    public void addDefinitions(Map<String, Definition> defsMap) throws NoSuchDefinitionException {
        this.baseDefinitions.putAll(defsMap);
        this.resolveInheritances();
    }

    @Override
    public void addDefinitions(Map<String, Definition> defsMap, Locale locale) throws NoSuchDefinitionException {
        this.localeSpecificDefinitions.put(locale, defsMap);
        this.resolveInheritances(locale);
    }

    @Override
    public Definition getDefinition(String name, Locale locale) {
        Map<String, Definition> localeSpecificMap;
        Definition definition = null;
        if (locale != null && (localeSpecificMap = this.localeSpecificDefinitions.get(locale)) != null) {
            definition = localeSpecificMap.get(name);
        }
        if (definition == null) {
            definition = this.getDefinition(name);
        }
        return definition;
    }

    @Override
    public void resolveInheritances() throws NoSuchDefinitionException {
        HashSet<String> alreadyResolvedDefinitions = new HashSet<String>();
        for (Definition definition : this.baseDefinitions.values()) {
            this.resolveInheritance(definition, null, alreadyResolvedDefinitions);
        }
    }

    @Override
    public void resolveInheritances(Locale locale) throws NoSuchDefinitionException {
        this.resolveInheritances();
        Map<String, Definition> map = this.localeSpecificDefinitions.get(locale);
        if (map != null) {
            HashSet<String> alreadyResolvedDefinitions = new HashSet<String>();
            for (Definition definition : map.values()) {
                this.resolveInheritance(definition, locale, alreadyResolvedDefinitions);
            }
        }
    }

    @Override
    public void reset() {
        this.baseDefinitions = new HashMap<String, Definition>();
        this.localeSpecificDefinitions = new HashMap<Locale, Map<String, Definition>>();
    }

    @Override
    public Map<String, Definition> getBaseDefinitions() {
        return this.baseDefinitions;
    }

    protected Definition getDefinitionByAttribute(Attribute attr, Locale locale) {
        Definition retValue = null;
        Object attrValue = attr.getValue();
        if (attrValue instanceof String) {
            retValue = this.getDefinition((String)attr.getValue(), locale);
        }
        return retValue;
    }

    protected void resolveInheritance(Definition definition, Locale locale, Set<String> alreadyResolvedDefinitions) throws NoSuchDefinitionException {
        if (!definition.isExtending() || alreadyResolvedDefinitions.contains(definition.getName())) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolve definition for child name='" + definition.getName() + "' extends='" + definition.getExtends() + "'."));
        }
        alreadyResolvedDefinitions.add(definition.getName());
        Definition parent = this.getDefinition(definition.getExtends(), locale);
        if (parent == null) {
            String msg = "Error while resolving definition inheritance: child '" + definition.getName() + "' can't find its ancestor '" + definition.getExtends() + "'. Please check your description file.";
            log.error((Object)msg);
            throw new NoSuchDefinitionException(msg);
        }
        this.resolveInheritance(parent, locale, alreadyResolvedDefinitions);
        this.overload(parent, definition);
    }

    protected void overload(Definition parent, Definition child) {
        for (Map.Entry<String, Attribute> entry : parent.getAttributes().entrySet()) {
            if (child.hasAttributeValue(entry.getKey())) continue;
            child.putAttribute(entry.getKey(), new Attribute(entry.getValue()));
        }
        if (child.getTemplate() == null) {
            child.setTemplate(parent.getTemplate());
        }
        if (child.getRole() == null) {
            child.setRole(parent.getRole());
        }
        if (child.getPreparer() == null) {
            child.setPreparer(parent.getPreparer());
        }
    }
}

