/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.portlet.context;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.portlet.context.PortletParamMap;
import org.apache.tiles.portlet.context.PortletParamValuesMap;
import org.apache.tiles.portlet.context.PortletRequestScopeMap;
import org.apache.tiles.portlet.context.PortletSessionScopeMap;
import org.apache.tiles.portlet.context.PortletTilesApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletTilesRequestContext
extends PortletTilesApplicationContext
implements TilesRequestContext {
    private Map<String, String> header = null;
    private Map<String, String[]> headerValues = null;
    protected PortletRequest request = null;
    private Map<String, Object> requestScope = null;
    protected PortletResponse response = null;
    private Map<String, Object> sessionScope = null;
    private boolean isRenderRequest;
    protected Map<String, String> param = null;
    protected Map<String, String[]> paramValues = null;

    public PortletTilesRequestContext(PortletContext context, PortletRequest request, PortletResponse response) {
        super(context);
        this.initialize(request, response);
    }

    public void initialize(PortletRequest request, PortletResponse response) {
        this.request = request;
        this.response = response;
        this.isRenderRequest = false;
        if (request != null && request instanceof RenderRequest) {
            this.isRenderRequest = true;
        }
    }

    @Override
    public void release() {
        this.header = null;
        this.headerValues = null;
        this.param = null;
        this.paramValues = null;
        this.requestScope = null;
        this.sessionScope = null;
        this.context = null;
        this.request = null;
        this.response = null;
        super.release();
    }

    public PortletRequest getRequest() {
        return this.request;
    }

    public PortletResponse getResponse() {
        return this.response;
    }

    @Override
    public Map<String, String> getHeader() {
        if (this.header == null && this.request != null) {
            this.header = Collections.EMPTY_MAP;
        }
        return this.header;
    }

    @Override
    public Map<String, String[]> getHeaderValues() {
        if (this.headerValues == null && this.request != null) {
            this.headerValues = Collections.EMPTY_MAP;
        }
        return this.headerValues;
    }

    @Override
    public Map<String, String> getParam() {
        if (this.param == null && this.request != null) {
            this.param = new PortletParamMap(this.request);
        }
        return this.param;
    }

    @Override
    public Map<String, String[]> getParamValues() {
        if (this.paramValues == null && this.request != null) {
            this.paramValues = new PortletParamValuesMap(this.request);
        }
        return this.paramValues;
    }

    @Override
    public Map<String, Object> getRequestScope() {
        if (this.requestScope == null && this.request != null) {
            this.requestScope = new PortletRequestScopeMap(this.request);
        }
        return this.requestScope;
    }

    @Override
    public Map<String, Object> getSessionScope() {
        if (this.sessionScope == null && this.request != null) {
            this.sessionScope = new PortletSessionScopeMap(this.request.getPortletSession());
        }
        return this.sessionScope;
    }

    @Override
    public void dispatch(String path) throws IOException {
        this.include(path);
    }

    @Override
    public void include(String path) throws IOException {
        if (this.isRenderRequest) {
            try {
                this.context.getRequestDispatcher(path).include((RenderRequest)this.request, (RenderResponse)this.response);
            }
            catch (PortletException e) {
                throw new IOException("PortletException while including path '" + path + "'." + e.getMessage());
            }
        }
    }

    @Override
    public Locale getRequestLocale() {
        if (this.request != null) {
            return this.request.getLocale();
        }
        return null;
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }
}

