/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.servlet.context.ServletApplicationScopeMap;
import org.apache.tiles.servlet.context.ServletInitParamMap;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTilesApplicationContext
implements TilesApplicationContext {
    private ServletContext servletContext;
    private Map<String, Object> applicationScope = null;
    private Map<String, String> initParam = null;

    public ServletTilesApplicationContext(ServletContext servletContext) {
        this.initialize(servletContext);
    }

    @Override
    public Map<String, Object> getApplicationScope() {
        if (this.applicationScope == null && this.servletContext != null) {
            this.applicationScope = new ServletApplicationScopeMap(this.servletContext);
        }
        return this.applicationScope;
    }

    @Override
    public Map<String, String> getInitParams() {
        if (this.initParam == null && this.servletContext != null) {
            this.initParam = new ServletInitParamMap(this.servletContext);
        }
        return this.initParam;
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.servletContext.getResource(path);
    }

    @Override
    public Set<URL> getResources(String path) throws MalformedURLException {
        HashSet<URL> urls = new HashSet<URL>();
        urls.add(this.getResource(path));
        return urls;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void initialize(ServletContext context) {
        this.servletContext = context;
    }

    public void release() {
        this.applicationScope = null;
        this.initParam = null;
        this.servletContext = null;
    }

    public TilesRequestContext createRequestContext(Object request, Object response) {
        if (request instanceof HttpServletRequest) {
            return new ServletTilesRequestContext(this.servletContext, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        throw new IllegalArgumentException("Invalid context specified. " + this.servletContext.getClass().getName());
    }
}

