/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import net.sf.jsr107cache.CacheException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.caching.core.CarbonCacheManager;

public final class CacheConfiguration {
    private static CacheConfiguration instance = new CacheConfiguration();
    public static final long DEFAULT_EXPIRATION = 900000L;
    public static final long DEFAULT_EXPIRATION_L1 = 600000L;
    public static final int MAX_ELEMENTS = 5000;
    public static final String CACHE_MODE_REPLICATED = "replicated";
    public static final String CACHE_MODE_DISTRIBUTED = "distributed";
    public static final String CACHE_MODE_INVALIDATION = "invalidation";
    public static final String CACHE_MODE_LOCAL = "local";
    private Map<String, List<String>> configuration = null;
    private CarbonCacheManager cacheManager = null;
    private static final Log log = LogFactory.getLog(CacheConfiguration.class);

    private CacheConfiguration() {
    }

    public static CacheConfiguration getInstance() {
        CarbonBaseUtils.checkSecurity();
        return instance;
    }

    public synchronized CarbonCacheManager getCacheManager() throws CacheException {
        if (this.cacheManager != null) {
            return this.cacheManager;
        }
        String cacheManagerClass = this.getProperty("cacheManager");
        if (cacheManagerClass == null) {
            throw new RuntimeException("The cache manager class was not defined");
        }
        try {
            Class<?> clazz = Class.forName(cacheManagerClass);
            this.cacheManager = (CarbonCacheManager)clazz.newInstance();
            return this.cacheManager;
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("No cache manager class by the name " + cacheManagerClass + " was found.", (Throwable)e);
        }
        catch (Exception e) {
            throw new CacheException("Unable to create an instance of a cache manager.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String configFilePath) throws CacheException {
        FileInputStream configInputStream;
        if (this.configuration != null) {
            return;
        }
        if (configFilePath == null) {
            throw new CacheException("the path of the cache configuration file was not specified.");
        }
        try {
            configInputStream = new FileInputStream(new File(configFilePath));
        }
        catch (FileNotFoundException e) {
            throw new CacheException("Cache configuration file (cache.xml) does not exist in the path " + configFilePath, (Throwable)e);
        }
        try {
            OMElement documentElement = new StAXOMBuilder((InputStream)configInputStream).getDocumentElement();
            HashMap<String, List<String>> configuration = new HashMap<String, List<String>>();
            this.readChildElements(documentElement, new Stack<String>(), configuration);
            CacheConfiguration cacheConfiguration = this;
            synchronized (cacheConfiguration) {
                if (this.configuration == null) {
                    this.configuration = configuration;
                }
            }
            log.debug((Object)"Successfully loaded Cache Configuration");
        }
        catch (XMLStreamException e) {
            throw new CacheException("Unable to parse the cache configuration.", (Throwable)e);
        }
        finally {
            try {
                ((InputStream)configInputStream).close();
            }
            catch (IOException ignore) {}
        }
    }

    private void readChildElements(OMElement cacheConfiguration, Stack<String> nameStack, Map<String, List<String>> configuration) {
        Iterator children = cacheConfiguration.getChildElements();
        while (children.hasNext()) {
            OMElement element = (OMElement)children.next();
            nameStack.push(element.getLocalName());
            String value = element.getText();
            if (value != null && (value = value.trim()).length() > 0) {
                String key = this.getKey(nameStack);
                List<String> currentObject = configuration.get(key);
                if (currentObject == null) {
                    currentObject = new ArrayList<String>(1);
                    currentObject.add(value);
                    configuration.put(key, currentObject);
                } else if (!currentObject.contains(value)) {
                    currentObject.add(value);
                    configuration.put(key, currentObject);
                }
            }
            this.readChildElements(element, nameStack, configuration);
            nameStack.pop();
        }
    }

    private String getKey(Stack<String> nameStack) {
        StringBuffer key = new StringBuffer((String)nameStack.elementAt(0));
        for (int i = 1; i < nameStack.size(); ++i) {
            key.append(".").append((String)nameStack.elementAt(i));
        }
        return key.toString();
    }

    public String getProperty(String key) {
        List<String> properties = this.configuration.get(key);
        return properties != null ? properties.get(0) : null;
    }

    public String[] getProperties(String key) {
        List<String> properties = this.configuration.get(key);
        return properties != null ? properties.toArray(new String[properties.size()]) : new String[]{};
    }
}

