/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.DataSourceInformationRepositoryListener;
import org.apache.synapse.commons.datasource.InMemoryDataSourceRepository;
import org.apache.synapse.commons.datasource.JNDIBasedDataSourceRepository;

public class DataSourceRepositoryManager
implements DataSourceInformationRepositoryListener {
    private static final Log log = LogFactory.getLog(DataSourceRepositoryManager.class);
    private final InMemoryDataSourceRepository inMemoryDataSourceRepository;
    private final JNDIBasedDataSourceRepository jndiBasedDataSourceRepository;

    public DataSourceRepositoryManager(InMemoryDataSourceRepository inMemoryDataSourceRepository, JNDIBasedDataSourceRepository jndiBasedDataSourceRepository) {
        this.inMemoryDataSourceRepository = inMemoryDataSourceRepository;
        this.jndiBasedDataSourceRepository = jndiBasedDataSourceRepository;
    }

    public DataSource getDataSource(String name) {
        if (name == null || "".equals(name)) {
            throw new SynapseCommonsException("DataSource name cannot be found.", log);
        }
        DataSource result = this.inMemoryDataSourceRepository.lookUp(name);
        if (result != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("DataSource is found in the in-memory data source repository. Datasource name is : " + name));
            }
            return result;
        }
        if (this.jndiBasedDataSourceRepository.isInitialized() && (result = this.jndiBasedDataSourceRepository.lookUp(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("DataSource is found in the JNDI data source repository. Datasource name is : " + name));
            }
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cannot find a datasource with name : " + name + " either in in-memory or" + " JNDI datasource repositories"));
        }
        return result;
    }

    @Override
    public void addDataSourceInformation(DataSourceInformation dataSourceInformation) {
        this.assertDataSourceInformationNull(dataSourceInformation);
        String repositoryType = dataSourceInformation.getRepositoryType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering a datasource in the repository : " + repositoryType + "." + " DataSource information is : " + dataSourceInformation));
        }
        if ("JNDI".equals(repositoryType)) {
            this.jndiBasedDataSourceRepository.register(dataSourceInformation);
        } else {
            this.inMemoryDataSourceRepository.register(dataSourceInformation);
        }
    }

    @Override
    public void removeDataSourceInformation(DataSourceInformation dataSourceInformation) {
        this.assertDataSourceInformationNull(dataSourceInformation);
        String repositoryType = dataSourceInformation.getRepositoryType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-Registering a datasource from the repository : " + repositoryType + "." + " DataSource information is : " + dataSourceInformation));
        }
        if ("JNDI".equals(repositoryType)) {
            this.jndiBasedDataSourceRepository.unRegister(dataSourceInformation.getDatasourceName());
        } else {
            this.inMemoryDataSourceRepository.unRegister(dataSourceInformation.getDatasourceName());
        }
    }

    @Override
    public void reConfigure(Properties confProperties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reconfiguring datasource repositories ");
        }
        this.jndiBasedDataSourceRepository.init(confProperties);
        this.inMemoryDataSourceRepository.init(confProperties);
    }

    public void clear() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clearing datasource repositories ");
        }
        if (this.inMemoryDataSourceRepository.isInitialized()) {
            this.inMemoryDataSourceRepository.clear();
        }
        if (this.jndiBasedDataSourceRepository.isInitialized()) {
            this.jndiBasedDataSourceRepository.clear();
        }
    }

    private void assertDataSourceInformationNull(DataSourceInformation dataSourceInformation) {
        if (dataSourceInformation == null) {
            throw new SynapseCommonsException("Provided DataSource Information instance is null", log);
        }
    }
}

