/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource.factory;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.wso2.securevault.secret.SecretInformation;
import org.wso2.securevault.secret.SecretInformationFactory;

public class DataSourceInformationFactory {
    private static final Log log = LogFactory.getLog(DataSourceInformationFactory.class);

    private DataSourceInformationFactory() {
    }

    public static DataSourceInformation createDataSourceInformation(String dsName, Properties properties) {
        String url;
        if (dsName == null || "".equals(dsName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DataSource name is either empty or null, ignoring..");
            }
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("synapse.datasources");
        buffer.append(".");
        buffer.append(dsName);
        buffer.append(".");
        String prefix = buffer.toString();
        String driver = MiscellaneousUtil.getProperty(properties, prefix + "driverClassName", null);
        if (driver == null) {
            DataSourceInformationFactory.handleException(prefix + "driverClassName" + " cannot be found.");
        }
        if ((url = MiscellaneousUtil.getProperty(properties, prefix + "url", null)) == null) {
            DataSourceInformationFactory.handleException(prefix + "url" + " cannot be found.");
        }
        DataSourceInformation datasourceInformation = new DataSourceInformation();
        datasourceInformation.setAlias(dsName);
        datasourceInformation.setDriver(driver);
        datasourceInformation.setUrl(url);
        String dataSourceName = MiscellaneousUtil.getProperty(properties, prefix + "dsName", dsName, String.class);
        datasourceInformation.setDatasourceName(dataSourceName);
        String dsType = MiscellaneousUtil.getProperty(properties, prefix + "type", "BasicDataSource", String.class);
        datasourceInformation.setType(dsType);
        String repositoryType = MiscellaneousUtil.getProperty(properties, prefix + "registry", "memory", String.class);
        datasourceInformation.setRepositoryType(repositoryType);
        Integer maxActive = MiscellaneousUtil.getProperty(properties, prefix + "maxActive", 8, Integer.class);
        datasourceInformation.setMaxActive(maxActive);
        Integer maxIdle = MiscellaneousUtil.getProperty(properties, prefix + "maxIdle", 8, Integer.class);
        datasourceInformation.setMaxIdle(maxIdle);
        Long maxWait = MiscellaneousUtil.getProperty(properties, prefix + "maxWait", -1L, Long.class);
        datasourceInformation.setMaxWait(maxWait);
        String suffix = "cpdsadapter.className";
        String className = MiscellaneousUtil.getProperty(properties, prefix + suffix, "org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS");
        datasourceInformation.addParameter(suffix, className);
        suffix = "cpdsadapter.factory";
        String factory = MiscellaneousUtil.getProperty(properties, prefix + suffix, "org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS");
        datasourceInformation.addParameter(suffix, factory);
        suffix = "cpdsadapter.name";
        String name = MiscellaneousUtil.getProperty(properties, prefix + suffix, "cpds");
        datasourceInformation.addParameter(suffix, name);
        boolean defaultAutoCommit = MiscellaneousUtil.getProperty(properties, prefix + "defaultAutoCommit", true, Boolean.class);
        boolean defaultReadOnly = MiscellaneousUtil.getProperty(properties, prefix + "defaultReadOnly", false, Boolean.class);
        boolean testOnBorrow = MiscellaneousUtil.getProperty(properties, prefix + "testOnBorrow", true, Boolean.class);
        boolean testOnReturn = MiscellaneousUtil.getProperty(properties, prefix + "testOnReturn", false, Boolean.class);
        long timeBetweenEvictionRunsMillis = MiscellaneousUtil.getProperty(properties, prefix + "timeBetweenEvictionRunsMillis", -1L, Long.class);
        int numTestsPerEvictionRun = MiscellaneousUtil.getProperty(properties, prefix + "numTestsPerEvictionRun", 3, Integer.class);
        long minEvictableIdleTimeMillis = MiscellaneousUtil.getProperty(properties, prefix + "minEvictableIdleTimeMillis", 1800000L, Long.class);
        boolean testWhileIdle = MiscellaneousUtil.getProperty(properties, prefix + "testWhileIdle", false, Boolean.class);
        String validationQuery = MiscellaneousUtil.getProperty(properties, prefix + "validationQuery", null);
        int minIdle = MiscellaneousUtil.getProperty(properties, prefix + "minIdle", 0, Integer.class);
        int initialSize = MiscellaneousUtil.getProperty(properties, prefix + "initialSize", 0, Integer.class);
        int defaultTransactionIsolation = MiscellaneousUtil.getProperty(properties, prefix + "defaultTransactionIsolation", -1, Integer.class);
        String defaultCatalog = MiscellaneousUtil.getProperty(properties, prefix + "defaultCatalog", null);
        boolean accessToUnderlyingConnectionAllowed = MiscellaneousUtil.getProperty(properties, prefix + "accessToUnderlyingConnectionAllowed", false, Boolean.class);
        boolean removeAbandoned = MiscellaneousUtil.getProperty(properties, prefix + "removeAbandoned", false, Boolean.class);
        int removeAbandonedTimeout = MiscellaneousUtil.getProperty(properties, prefix + "removeAbandonedTimeout", 300, Integer.class);
        boolean logAbandoned = MiscellaneousUtil.getProperty(properties, prefix + "logAbandoned", false, Boolean.class);
        boolean poolPreparedStatements = MiscellaneousUtil.getProperty(properties, prefix + "poolPreparedStatements", false, Boolean.class);
        int maxOpenPreparedStatements = MiscellaneousUtil.getProperty(properties, prefix + "maxOpenPreparedStatements", -1, Integer.class);
        datasourceInformation.setDefaultAutoCommit(defaultAutoCommit);
        datasourceInformation.setDefaultReadOnly(defaultReadOnly);
        datasourceInformation.setTestOnBorrow(testOnBorrow);
        datasourceInformation.setTestOnReturn(testOnReturn);
        datasourceInformation.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        datasourceInformation.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        datasourceInformation.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        datasourceInformation.setTestWhileIdle(testWhileIdle);
        datasourceInformation.setMinIdle(minIdle);
        datasourceInformation.setDefaultTransactionIsolation(defaultTransactionIsolation);
        datasourceInformation.setAccessToUnderlyingConnectionAllowed(accessToUnderlyingConnectionAllowed);
        datasourceInformation.setRemoveAbandoned(removeAbandoned);
        datasourceInformation.setRemoveAbandonedTimeout(removeAbandonedTimeout);
        datasourceInformation.setLogAbandoned(logAbandoned);
        datasourceInformation.setPoolPreparedStatements(poolPreparedStatements);
        datasourceInformation.setMaxOpenPreparedStatements(maxOpenPreparedStatements);
        datasourceInformation.setInitialSize(initialSize);
        if (validationQuery != null && !"".equals(validationQuery)) {
            datasourceInformation.setValidationQuery(validationQuery);
        }
        if (defaultCatalog != null && !"".equals(defaultCatalog)) {
            datasourceInformation.setDefaultCatalog(defaultCatalog);
        }
        datasourceInformation.addProperty(prefix + "icFactory", MiscellaneousUtil.getProperty(properties, prefix + "icFactory", null));
        datasourceInformation.addProperty(prefix + "providerUrl", MiscellaneousUtil.getProperty(properties, prefix + "providerUrl", null));
        datasourceInformation.addProperty(prefix + "providerPort", MiscellaneousUtil.getProperty(properties, prefix + "providerPort", null));
        String passwordPrompt = MiscellaneousUtil.getProperty(properties, prefix + "passwordPrompt", "Password for datasource " + dsName, String.class);
        SecretInformation secretInformation = SecretInformationFactory.createSecretInformation((Properties)properties, (String)prefix, (String)passwordPrompt);
        secretInformation.setToken(dsName + "." + "password");
        datasourceInformation.setSecretInformation(secretInformation);
        return datasourceInformation;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseCommonsException(msg);
    }
}

