/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.client.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.EncryptedKeyToken;
import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.SupportingPolicyData;
import org.apache.rampart.policy.model.KerberosConfig;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.KerberosTokenPrincipal;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecKerberosToken;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecSignatureConfirmation;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BindingBuilder {
    private static Log log = LogFactory.getLog(BindingBuilder.class);
    private Element insertionLocation;
    protected String mainSigId = null;
    protected ArrayList encryptedTokensIdList = new ArrayList();
    protected Element timestampElement;
    protected Element mainRefListElement;

    protected void addTimestamp(RampartMessageData rmd) {
        log.debug((Object)"Adding timestamp");
        WSSecTimestamp timestampBuilder = new WSSecTimestamp();
        timestampBuilder.setWsConfig(rmd.getConfig());
        timestampBuilder.setTimeToLive(RampartUtil.getTimeToLive(rmd));
        timestampBuilder.build(rmd.getDocument(), rmd.getSecHeader());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Timestamp id: " + timestampBuilder.getId()));
        }
        rmd.setTimestampId(timestampBuilder.getId());
        this.timestampElement = timestampBuilder.getElement();
        log.debug((Object)"Adding timestamp: DONE");
    }

    protected WSSecUsernameToken addUsernameToken(RampartMessageData rmd, UsernameToken token) throws RampartException {
        log.debug((Object)"Adding a UsernameToken");
        RampartPolicyData rpd = rmd.getPolicyData();
        Options options = rmd.getMsgContext().getOptions();
        String user = options.getUserName();
        if ((user == null || user.length() == 0) && rpd.getRampartConfig() != null) {
            user = rpd.getRampartConfig().getUser();
        }
        if (user != null && !"".equals(user)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User : " + user));
            }
            if (token.isNoPassword()) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken();
                utBuilder.setUserInfo(user, null);
                utBuilder.setPasswordType(null);
                if (rmd.getConfig() != null) {
                    utBuilder.setWsConfig(rmd.getConfig());
                }
                return utBuilder;
            }
            String password = options.getPassword();
            if (password == null || password.length() == 0) {
                CallbackHandler handler = RampartUtil.getPasswordCB(rmd);
                if (handler == null) {
                    throw new RampartException("cbHandlerMissing");
                }
                WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(user, 2)};
                try {
                    handler.handle((Callback[])cb);
                }
                catch (Exception e) {
                    throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
                }
                password = cb[0].getPassword();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Password : " + password));
            }
            if (password != null && !"".equals(password)) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken();
                if (rmd.getConfig() != null) {
                    utBuilder.setWsConfig(rmd.getConfig());
                }
                if (token.isHashPassword()) {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                utBuilder.setUserInfo(user, password);
                return utBuilder;
            }
            throw new RampartException("noPasswordForUser", new String[]{user});
        }
        log.debug((Object)"No user value specified in the configuration");
        throw new RampartException("userMissing");
    }

    protected WSSecEncryptedKey getEncryptedKeyBuilder(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
        try {
            RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)encrKey, token);
            RampartUtil.setEncryptionUser(rmd, encrKey);
            encrKey.setKeySize(rpd.getAlgorithmSuite().getMaximumSymmetricKeyLength());
            encrKey.setKeyEncAlgo(rpd.getAlgorithmSuite().getAsymmetricKeyWrap());
            encrKey.prepare(doc, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
            return encrKey;
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorCreatingEncryptedKey", e);
        }
    }

    @Deprecated
    protected WSSecSignature getSignatureBuider(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token) throws RampartException {
        return this.getSignatureBuilder(rmd, token, null);
    }

    @Deprecated
    protected WSSecSignature getSignatureBuider(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token, String userCertAlias) throws RampartException {
        return this.getSignatureBuilder(rmd, token, userCertAlias);
    }

    protected WSSecSignature getSignatureBuilder(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token) throws RampartException {
        return this.getSignatureBuilder(rmd, token, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WSSecSignature getSignatureBuilder(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token, String userCertAlias) throws RampartException {
        String password;
        String user;
        WSSecSignature sig;
        RampartPolicyData rpd;
        block14: {
            rpd = rmd.getPolicyData();
            sig = new WSSecSignature();
            this.checkForX509PkiPath(sig, token);
            sig.setWsConfig(rmd.getConfig());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token inclusion: " + token.getInclusion()));
            }
            RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)sig, token);
            user = null;
            if (userCertAlias != null) {
                user = userCertAlias;
            }
            if (user == null) {
                user = rpd.getRampartConfig().getUserCertAlias();
            }
            if (user == null) {
                user = rpd.getRampartConfig().getUser();
            }
            password = null;
            if (user != null && !"".equals(user)) {
                CallbackHandler handler;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User : " + user));
                }
                if ((handler = RampartUtil.getPasswordCB(rmd)) == null) {
                    throw new RampartException("cbHandlerMissing");
                }
                WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(user, 3)};
                try {
                    handler.handle((Callback[])cb);
                    if (cb[0].getPassword() != null && !"".equals(cb[0].getPassword())) {
                        password = cb[0].getPassword();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Password : " + password));
                        }
                        break block14;
                    }
                    throw new RampartException("noPasswordForUser", new String[]{user});
                }
                catch (IOException e) {
                    throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
                }
                catch (UnsupportedCallbackException e) {
                    throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
                }
            }
            log.debug((Object)"No user value specified in the configuration");
            throw new RampartException("userMissing");
        }
        sig.setUserInfo(user, password);
        sig.setSignatureAlgorithm(rpd.getAlgorithmSuite().getAsymmetricSignature());
        sig.setSigCanonicalization(rpd.getAlgorithmSuite().getInclusiveC14n());
        try {
            sig.prepare(rmd.getDocument(), RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()), rmd.getSecHeader());
            return sig;
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
    }

    protected HashMap handleSupportingTokens(RampartMessageData rmd, SupportingToken suppTokens) throws RampartException {
        HashMap<String, Element> endSuppTokMap = new HashMap<String, Element>();
        if (suppTokens != null && suppTokens.getTokens() != null && suppTokens.getTokens().size() > 0) {
            log.debug((Object)"Processing supporting tokens");
            ArrayList tokens = suppTokens.getTokens();
            for (org.apache.ws.secpolicy.model.Token token : tokens) {
                Token endSuppTok = null;
                if (token instanceof IssuedToken && rmd.isInitiator()) {
                    String id = RampartUtil.getIssuedToken(rmd, (IssuedToken)token);
                    try {
                        endSuppTok = rmd.getTokenStorage().getToken(id);
                    }
                    catch (TrustException e) {
                        throw new RampartException("errorInRetrievingTokenId", new String[]{id}, e);
                    }
                    if (endSuppTok == null) {
                        throw new RampartException("errorInRetrievingTokenId", new String[]{id});
                    }
                    Element siblingElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), (Element)endSuppTok.getToken());
                    this.setInsertionLocation(siblingElem);
                    if (suppTokens.isEncryptedToken()) {
                        this.encryptedTokensIdList.add(endSuppTok.getId());
                    }
                    Element strElem = TrustUtil.createSecurityTokenReference((Document)rmd.getSecHeader().getSecurityHeader().getOwnerDocument(), (String)id, (String)"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                    Element strElemInserted = RampartUtil.insertSiblingAfter(rmd, siblingElem, strElem);
                    this.setInsertionLocation(strElemInserted);
                    String elementID = RampartUtil.addWsuIdToElement((OMElement)strElemInserted);
                    endSuppTokMap.put(elementID, strElemInserted);
                    continue;
                }
                if (token instanceof X509Token) {
                    WSSecSignature sig = this.getSignatureBuilder(rmd, token);
                    Element bstElem = sig.getBinarySecurityTokenElement();
                    if (bstElem != null) {
                        bstElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), bstElem);
                        this.setInsertionLocation(bstElem);
                        SupportingPolicyData supportingPolcy = new SupportingPolicyData();
                        supportingPolcy.build(suppTokens);
                        supportingPolcy.setSignatureToken(token);
                        supportingPolcy.setEncryptionToken(token);
                        rmd.getPolicyData().addSupportingPolicyData(supportingPolcy);
                        if (suppTokens.isEncryptedToken()) {
                            this.encryptedTokensIdList.add(sig.getBSTTokenId());
                        }
                    }
                    endSuppTokMap.put((String)token, (Element)sig);
                    continue;
                }
                if (!(token instanceof UsernameToken)) continue;
                WSSecUsernameToken utBuilder = this.addUsernameToken(rmd, (UsernameToken)token);
                utBuilder.prepare(rmd.getDocument());
                Element elem = utBuilder.getUsernameTokenElement();
                elem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), elem);
                this.encryptedTokensIdList.add(utBuilder.getId());
                this.setInsertionLocation(elem);
                Date now = new Date();
                try {
                    Token tempTok = new Token(utBuilder.getId(), (OMElement)elem, now, new Date(now.getTime() + 300000L));
                    endSuppTokMap.put((String)token, (Element)tempTok);
                }
                catch (TrustException e) {
                    throw new RampartException("errorCreatingRahasToken", e);
                }
            }
        }
        return endSuppTokMap;
    }

    protected Vector addSignatureParts(HashMap tokenMap, Vector sigParts) throws RampartException {
        Set entrySet = tokenMap.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Object tempTok = iter.next().getValue();
            WSEncryptionPart part = null;
            if (tempTok instanceof Token) {
                part = new WSEncryptionPart(((Token)tempTok).getId());
            } else if (tempTok instanceof WSSecSignature) {
                WSSecSignature tempSig = (WSSecSignature)tempTok;
                if (tempSig.getBSTTokenId() != null) {
                    part = new WSEncryptionPart(tempSig.getBSTTokenId());
                }
            } else if (tempTok instanceof OMElement && "SecurityTokenReference".equals(((OMElement)tempTok).getLocalName())) {
                String id = ((OMElement)tempTok).getAttributeValue(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu"));
                if (id != null) {
                    part = new WSEncryptionPart(id);
                    part.setName("SecurityTokenReference");
                }
            } else {
                throw new RampartException("UnsupportedTokenInSupportingToken");
            }
            sigParts.add(part);
        }
        return sigParts;
    }

    public Element getInsertionLocation() {
        return this.insertionLocation;
    }

    public void setInsertionLocation(Element insertionLocation) {
        this.insertionLocation = insertionLocation;
    }

    protected Vector doEndorsedSignatures(RampartMessageData rmd, HashMap tokenMap) throws RampartException {
        Set tokenSet = tokenMap.keySet();
        Vector<byte[]> sigValues = new Vector<byte[]>();
        for (org.apache.ws.secpolicy.model.Token token : tokenSet) {
            Object tempTok = tokenMap.get(token);
            Vector<WSEncryptionPart> sigParts = new Vector<WSEncryptionPart>();
            sigParts.add(new WSEncryptionPart(this.mainSigId));
            if (tempTok instanceof Token) {
                Token tok = (Token)tempTok;
                if (rmd.getPolicyData().isTokenProtection()) {
                    sigParts.add(new WSEncryptionPart(tok.getId()));
                }
                this.doSymmSignature(rmd, token, (Token)tempTok, sigParts);
                continue;
            }
            if (!(tempTok instanceof WSSecSignature)) continue;
            WSSecSignature sig = (WSSecSignature)tempTok;
            if (rmd.getPolicyData().isTokenProtection() && sig.getBSTTokenId() != null) {
                sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
            }
            try {
                sig.addReferencesToSign(sigParts, rmd.getSecHeader());
                sig.computeSignature();
                this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), sig.getSignatureElement()));
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInSignatureWithX509Token", e);
            }
            sigValues.add(sig.getSignatureValue());
        }
        return sigValues;
    }

    protected byte[] doSymmSignature(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token policyToken, Token tok, Vector sigParts) throws RampartException {
        Document doc = rmd.getDocument();
        RampartPolicyData rpd = rmd.getPolicyData();
        if (policyToken.isDerivedKeys()) {
            try {
                OMElement ref;
                WSSecDKSign dkSign = new WSSecDKSign();
                if (2 == policyToken.getVersion()) {
                    dkSign.setWscVersion(2);
                }
                boolean attached = false;
                if (5 == policyToken.getInclusion() || 2 == policyToken.getInclusion() || rmd.isInitiator() && 3 == policyToken.getInclusion()) {
                    attached = true;
                }
                if ((ref = attached ? tok.getAttachedReference() : tok.getUnattachedReference()) != null) {
                    dkSign.setExternalKey(tok.getSecret(), (Element)doc.importNode((Element)ref, true));
                } else if (!rmd.isInitiator() && policyToken.isDerivedKeys()) {
                    SecurityTokenReference tokenRef = new SecurityTokenReference(doc);
                    if (tok instanceof EncryptedKeyToken) {
                        tokenRef.setKeyIdentifierEncKeySHA1(((EncryptedKeyToken)tok).getSHA1());
                    }
                    dkSign.setExternalKey(tok.getSecret(), tokenRef.getElement());
                } else {
                    dkSign.setExternalKey(tok.getSecret(), tok.getId());
                }
                dkSign.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
                dkSign.setDerivedKeyLength(rpd.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
                if (tok instanceof EncryptedKeyToken) {
                    dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                }
                dkSign.prepare(doc, rmd.getSecHeader());
                if (rpd.isTokenProtection()) {
                    String sigTokId = tok.getId();
                    if (sigTokId.startsWith("#")) {
                        sigTokId = sigTokId.substring(1);
                    }
                    sigParts.add(new WSEncryptionPart(sigTokId));
                }
                dkSign.setParts(sigParts);
                dkSign.addReferencesToSign(sigParts, rmd.getSecHeader());
                dkSign.computeSignature();
                if (rpd.getProtectionOrder().equals("EncryptBeforeSigning") && this.getInsertionLocation() == null) {
                    this.setInsertionLocation(RampartUtil.insertSiblingBefore(rmd, this.mainRefListElement, dkSign.getdktElement()));
                    this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), dkSign.getSignatureElement()));
                } else {
                    this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), dkSign.getdktElement()));
                    this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), dkSign.getSignatureElement()));
                }
                return dkSign.getSignatureValue();
            }
            catch (ConversationException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            String sigTokId;
            WSSecSignature sig = new WSSecSignature();
            sig.setWsConfig(rmd.getConfig());
            if (policyToken instanceof X509Token) {
                if (rmd.isInitiator()) {
                    sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    sig.setKeyIdentifierType(9);
                } else {
                    sig.setEncrKeySha1value(((EncryptedKeyToken)tok).getSHA1());
                    sig.setKeyIdentifierType(10);
                }
            } else if (policyToken instanceof IssuedToken) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                sig.setKeyIdentifierType(15);
            }
            if (policyToken instanceof SecureConversationToken) {
                sig.setKeyIdentifierType(9);
                OMElement ref = tok.getAttachedReference();
                if (ref == null) {
                    ref = tok.getUnattachedReference();
                }
                sigTokId = ref != null ? SimpleTokenStore.getIdFromSTR((OMElement)ref) : tok.getId();
            } else {
                sigTokId = tok.getId();
            }
            if (sigTokId.startsWith("#")) {
                sigTokId = sigTokId.substring(1);
            }
            sig.setCustomTokenId(sigTokId);
            sig.setSecretKey(tok.getSecret());
            sig.setSignatureAlgorithm(rpd.getAlgorithmSuite().getAsymmetricSignature());
            sig.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
            sig.prepare(rmd.getDocument(), RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()), rmd.getSecHeader());
            sig.setParts(sigParts);
            sig.addReferencesToSign(sigParts, rmd.getSecHeader());
            sig.computeSignature();
            if (rpd.getProtectionOrder().equals("EncryptBeforeSigning") && this.getInsertionLocation() == null) {
                this.setInsertionLocation(RampartUtil.insertSiblingBefore(rmd, this.mainRefListElement, sig.getSignatureElement()));
            } else {
                this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), sig.getSignatureElement()));
            }
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithACustomToken", e);
        }
    }

    protected Token getToken(RampartMessageData rmd, String tokenId) throws RampartException {
        Token tok = null;
        try {
            tok = rmd.getTokenStorage().getToken(tokenId);
        }
        catch (TrustException e) {
            throw new RampartException("errorInRetrievingTokenId", new String[]{tokenId}, e);
        }
        if (tok == null) {
            throw new RampartException("errorInRetrievingTokenId", new String[]{tokenId});
        }
        return tok;
    }

    protected void addSignatureConfirmation(RampartMessageData rmd, Vector sigParts) {
        if (!rmd.getPolicyData().isSignatureConfirmation()) {
            return;
        }
        Document doc = rmd.getDocument();
        Vector results = (Vector)rmd.getMsgContext().getProperty("RECV_RESULTS");
        Vector signatureActions = new Vector();
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult wshResult = (WSHandlerResult)results.get(i);
            WSSecurityUtil.fetchAllActionResults((Vector)wshResult.getResults(), (int)2, signatureActions);
            WSSecurityUtil.fetchAllActionResults((Vector)wshResult.getResults(), (int)16, signatureActions);
            WSSecurityUtil.fetchAllActionResults((Vector)wshResult.getResults(), (int)64, signatureActions);
            WSSecurityUtil.fetchAllActionResults((Vector)wshResult.getResults(), (int)5120, signatureActions);
        }
        WSSecSignatureConfirmation wsc = new WSSecSignatureConfirmation();
        if (signatureActions.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signature Confirmation: number of Signature results: " + signatureActions.size()));
            }
            for (int i = 0; i < signatureActions.size(); ++i) {
                WSSecurityEngineResult wsr = (WSSecurityEngineResult)signatureActions.get(i);
                byte[] sigVal = (byte[])wsr.get((Object)"signature-value");
                wsc.setSignatureValue(sigVal);
                wsc.prepare(doc);
                RampartUtil.appendChildToSecHeader(rmd, wsc.getSignatureConfirmationElement());
                if (sigParts == null) continue;
                sigParts.add(new WSEncryptionPart(wsc.getId()));
            }
        } else {
            wsc.prepare(doc);
            RampartUtil.appendChildToSecHeader(rmd, wsc.getSignatureConfirmationElement());
            if (sigParts != null) {
                sigParts.add(new WSEncryptionPart(wsc.getId()));
            }
        }
    }

    protected WSSecKerberosToken getKerberosTokenBuilder(RampartMessageData rmd, org.apache.ws.secpolicy.model.Token token) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        KerberosConfig krbConfig = rpd.getRampartConfig().getKerberosConfig();
        if (krbConfig == null || krbConfig.getProp() == null) {
            throw new RampartException("noKerberosConfigDefined");
        }
        WSSecKerberosToken krb = new WSSecKerberosToken();
        krb.setWsConfig(rmd.getConfig());
        log.debug((Object)("Token inclusion: " + token.getInclusion()));
        RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)krb, token);
        String user = null;
        String passwordFromConfig = null;
        String clientPricipal = null;
        String servicePrincipal = null;
        String password = null;
        String service = null;
        clientPricipal = (String)rmd.getMsgContext().getProperty("client.principal.name");
        servicePrincipal = (String)rmd.getMsgContext().getProperty("service.principal.name");
        if (clientPricipal == null || servicePrincipal == null || rmd.isInitiator()) {
            user = krbConfig.getProp().getProperty("client.principal.name");
            passwordFromConfig = krbConfig.getProp().getProperty("client.principal.password");
            if (passwordFromConfig == null) {
                passwordFromConfig = krbConfig.getProp().getProperty("service.principal.password");
            }
            if (user == null) {
                user = rpd.getRampartConfig().getUser();
            }
            if (user != null && !"".equals(user)) {
                log.debug((Object)("User : " + user));
                CallbackHandler handler = RampartUtil.getPasswordCB(rmd);
                if (handler != null) {
                    WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(user, 9)};
                    try {
                        handler.handle((Callback[])cb);
                        if (cb[0].getPassword() != null && !"".equals(cb[0].getPassword())) {
                            password = cb[0].getPassword();
                            log.debug((Object)("Password : " + password));
                        }
                        password = passwordFromConfig;
                    }
                    catch (IOException e) {
                        throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
                    }
                    catch (UnsupportedCallbackException e) {
                        throw new RampartException("errorInGettingPasswordForUser", new String[]{user}, e);
                    }
                } else {
                    password = passwordFromConfig;
                }
            }
            service = krbConfig.getProp().getProperty("service.principal.name");
        } else {
            user = clientPricipal;
            service = servicePrincipal;
        }
        krb.setUserInfo(user, password);
        krb.setServicePrincipalName(service);
        if (!rmd.isInitiator()) {
            krb.setReceiver(true);
        }
        try {
            krb.build(rmd.getDocument(), rmd.getSecHeader());
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInBuilingKereberosToken", e);
        }
        if (!rmd.isInitiator()) {
            this.setKerberosToken(rmd, krb);
        }
        return krb;
    }

    private void setKerberosToken(RampartMessageData rmd, WSSecKerberosToken krbToken) throws RampartException {
        Vector results = (Vector)rmd.getMsgContext().getProperty("RECV_RESULTS");
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 5120) continue;
                KerberosTokenPrincipal principal = (KerberosTokenPrincipal)wser.get((Object)"principal");
                try {
                    BinarySecurity token = new BinarySecurity(principal.getTokenElement());
                    krbToken.setBSTToken(token);
                    continue;
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorExtractingKereberosToken");
                }
            }
        }
    }

    private void checkForX509PkiPath(WSSecSignature sig, org.apache.ws.secpolicy.model.Token token) {
        X509Token x509Token;
        if (token instanceof X509Token && ((x509Token = (X509Token)token).getTokenVersionAndType().equals("WssX509PkiPathV1Token10") || x509Token.getTokenVersionAndType().equals("WssX509PkiPathV1Token11"))) {
            sig.setUseSingleCertificate(false);
        }
    }
}

